package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class JobSpecBuilder extends JobSpecFluentImpl<JobSpecBuilder> implements VisitableBuilder<JobSpec,JobSpecBuilder>{

    JobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JobSpecBuilder(){
            this(true);
    }
    public JobSpecBuilder(Boolean validationEnabled){
            this(new JobSpec(), validationEnabled);
    }
    public JobSpecBuilder(JobSpecFluent<?> fluent){
            this(fluent, true);
    }
    public JobSpecBuilder(JobSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JobSpec(), validationEnabled);
    }
    public JobSpecBuilder(JobSpecFluent<?> fluent,JobSpec instance){
            this(fluent, instance, true);
    }
    public JobSpecBuilder(JobSpecFluent<?> fluent,JobSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
            fluent.withAutoSelector(instance.getAutoSelector()); 
            fluent.withCompletions(instance.getCompletions()); 
            fluent.withParallelism(instance.getParallelism()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public JobSpecBuilder(JobSpec instance){
            this(instance,true);
    }
    public JobSpecBuilder(JobSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
            this.withAutoSelector(instance.getAutoSelector()); 
            this.withCompletions(instance.getCompletions()); 
            this.withParallelism(instance.getParallelism()); 
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }

    public JobSpec build(){
            JobSpec buildable = new JobSpec(fluent.getActiveDeadlineSeconds(),fluent.isAutoSelector(),fluent.getCompletions(),fluent.getParallelism(),fluent.getSelector(),fluent.getTemplate());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JobSpecBuilder that = (JobSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
