package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import lombok.ToString;

public class PetSetSpecFluentImpl<A extends PetSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PetSetSpecFluent<A>{

    private Integer replicas;
    private VisitableBuilder<? extends LabelSelector,?> selector;
    private String serviceName;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;
    private List<VisitableBuilder<? extends PersistentVolumeClaim,?>> volumeClaimTemplates =  new ArrayList<VisitableBuilder<? extends PersistentVolumeClaim,?>>();

    public PetSetSpecFluentImpl(){
    }
    public PetSetSpecFluentImpl(PetSetSpec instance){
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withServiceName(instance.getServiceName()); 
            this.withTemplate(instance.getTemplate()); 
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public PetSetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public PetSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public PetSetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public PetSetSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public PetSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public PetSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public PetSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public PetSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public A addToVolumeClaimTemplates(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
    }

    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.volumeClaimTemplates.remove(builder);} return (A)this;
    }

    public List<PersistentVolumeClaim> getVolumeClaimTemplates(){
            return build(volumeClaimTemplates);
    }

    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates){
            _visitables.removeAll(this.volumeClaimTemplates);
            this.volumeClaimTemplates.clear();
            if (volumeClaimTemplates != null) {for (PersistentVolumeClaim item : volumeClaimTemplates){this.addToVolumeClaimTemplates(item);}} return (A) this;
    }

    public A withVolumeClaimTemplates(PersistentVolumeClaim... volumeClaimTemplates){
            this.volumeClaimTemplates.clear(); if (volumeClaimTemplates != null) {for (PersistentVolumeClaim item :volumeClaimTemplates){ this.addToVolumeClaimTemplates(item);}} return (A) this;
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate(){
            return new VolumeClaimTemplatesNestedImpl();
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item){
            return new VolumeClaimTemplatesNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetSpecFluentImpl that = (PetSetSpecFluentImpl) o;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (volumeClaimTemplates != null ? !volumeClaimTemplates.equals(that.volumeClaimTemplates) :that.volumeClaimTemplates != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PetSetSpecFluent.SelectorNested<N>> implements PetSetSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LabelSelectorBuilder builder;
    
            SelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) PetSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<PetSetSpecFluent.TemplateNested<N>> implements PetSetSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) PetSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class VolumeClaimTemplatesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PetSetSpecFluent.VolumeClaimTemplatesNested<N>> implements PetSetSpecFluent.VolumeClaimTemplatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            VolumeClaimTemplatesNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            VolumeClaimTemplatesNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) PetSetSpecFluentImpl.this.addToVolumeClaimTemplates(builder.build());
    }
    public N endVolumeClaimTemplate(){
            return and();
    }

}


}
