package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class RollingUpdateDeploymentBuilder extends RollingUpdateDeploymentFluentImpl<RollingUpdateDeploymentBuilder> implements VisitableBuilder<RollingUpdateDeployment,RollingUpdateDeploymentBuilder>{

    RollingUpdateDeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public RollingUpdateDeploymentBuilder(){
            this(true);
    }
    public RollingUpdateDeploymentBuilder(Boolean validationEnabled){
            this(new RollingUpdateDeployment(), validationEnabled);
    }
    public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RollingUpdateDeployment(), validationEnabled);
    }
    public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent,RollingUpdateDeployment instance){
            this(fluent, instance, true);
    }
    public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent,RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxSurge(instance.getMaxSurge()); 
            fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
            this.validationEnabled = validationEnabled; 
    }
    public RollingUpdateDeploymentBuilder(RollingUpdateDeployment instance){
            this(instance,true);
    }
    public RollingUpdateDeploymentBuilder(RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxSurge(instance.getMaxSurge()); 
            this.withMaxUnavailable(instance.getMaxUnavailable()); 
            this.validationEnabled = validationEnabled; 
    }

    public RollingUpdateDeployment build(){
            RollingUpdateDeployment buildable = new RollingUpdateDeployment(fluent.getMaxSurge(),fluent.getMaxUnavailable());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RollingUpdateDeploymentBuilder that = (RollingUpdateDeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
