package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ScaleFluent<A extends ScaleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ScaleFluent.MetadataNested<A> withNewMetadata();
    public ScaleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ScaleFluent.MetadataNested<A> editMetadata();
    public ScaleFluent.MetadataNested<A> editOrNewMetadata();
    public ScaleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ScaleSpec getSpec();
    public A withSpec(ScaleSpec spec);
    public ScaleFluent.SpecNested<A> withNewSpec();
    public ScaleFluent.SpecNested<A> withNewSpecLike(ScaleSpec item);
    public ScaleFluent.SpecNested<A> editSpec();
    public ScaleFluent.SpecNested<A> editOrNewSpec();
    public ScaleFluent.SpecNested<A> editOrNewSpecLike(ScaleSpec item);
    public A withNewSpec(Integer replicas);
    public ScaleStatus getStatus();
    public A withStatus(ScaleStatus status);
    public ScaleFluent.StatusNested<A> withNewStatus();
    public ScaleFluent.StatusNested<A> withNewStatusLike(ScaleStatus item);
    public ScaleFluent.StatusNested<A> editStatus();
    public ScaleFluent.StatusNested<A> editOrNewStatus();
    public ScaleFluent.StatusNested<A> editOrNewStatusLike(ScaleStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ScaleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScaleSpecFluent<ScaleFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScaleStatusFluent<ScaleFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
