package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface BuildConfigSpecFluent<A extends BuildConfigSpecFluent<A>> extends Fluent<A>{


    public Long getCompletionDeadlineSeconds();
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds);
    public BuildOutput getOutput();
    public A withOutput(BuildOutput output);
    public BuildConfigSpecFluent.OutputNested<A> withNewOutput();
    public BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item);
    public BuildConfigSpecFluent.OutputNested<A> editOutput();
    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutput();
    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item);
    public BuildPostCommitSpec getPostCommit();
    public A withPostCommit(BuildPostCommitSpec postCommit);
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit();
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item);
    public BuildConfigSpecFluent.PostCommitNested<A> editPostCommit();
    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit();
    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResources();
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public BuildConfigSpecFluent.ResourcesNested<A> editResources();
    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources();
    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    public SourceRevision getRevision();
    public A withRevision(SourceRevision revision);
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevision();
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public BuildConfigSpecFluent.RevisionNested<A> editRevision();
    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision();
    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item);
    public String getRunPolicy();
    public A withRunPolicy(String runPolicy);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public BuildSource getSource();
    public A withSource(BuildSource source);
    public BuildConfigSpecFluent.SourceNested<A> withNewSource();
    public BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item);
    public BuildConfigSpecFluent.SourceNested<A> editSource();
    public BuildConfigSpecFluent.SourceNested<A> editOrNewSource();
    public BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item);
    public BuildStrategy getStrategy();
    public A withStrategy(BuildStrategy strategy);
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy();
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item);
    public BuildConfigSpecFluent.StrategyNested<A> editStrategy();
    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy();
    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item);
    public A addToTriggers(BuildTriggerPolicy... items);
    public A removeFromTriggers(BuildTriggerPolicy... items);
    public List<BuildTriggerPolicy> getTriggers();
    public A withTriggers(List<BuildTriggerPolicy> triggers);
    public A withTriggers(BuildTriggerPolicy... triggers);
    public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger();
    public BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item);

    public interface OutputNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildOutputFluent<BuildConfigSpecFluent.OutputNested<N>>{

        
    public N and();    public N endOutput();
}
    public interface PostCommitNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildPostCommitSpecFluent<BuildConfigSpecFluent.PostCommitNested<N>>{

        
    public N and();    public N endPostCommit();
}
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<BuildConfigSpecFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface RevisionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceRevisionFluent<BuildConfigSpecFluent.RevisionNested<N>>{

        
    public N and();    public N endRevision();
}
    public interface SourceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildSourceFluent<BuildConfigSpecFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}
    public interface StrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildStrategyFluent<BuildConfigSpecFluent.StrategyNested<N>>{

        
    public N and();    public N endStrategy();
}
    public interface TriggersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildTriggerPolicyFluent<BuildConfigSpecFluent.TriggersNested<N>>{

        
    public N and();    public N endTrigger();
}


}
