package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import lombok.EqualsAndHashCode;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.ToString;

public class BuildConfigSpecFluentImpl<A extends BuildConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildConfigSpecFluent<A>{

    private Long completionDeadlineSeconds;
    private VisitableBuilder<? extends BuildOutput,?> output;
    private VisitableBuilder<? extends BuildPostCommitSpec,?> postCommit;
    private VisitableBuilder<? extends ResourceRequirements,?> resources;
    private VisitableBuilder<? extends SourceRevision,?> revision;
    private String runPolicy;
    private String serviceAccount;
    private VisitableBuilder<? extends BuildSource,?> source;
    private VisitableBuilder<? extends BuildStrategy,?> strategy;
    private List<VisitableBuilder<? extends BuildTriggerPolicy,?>> triggers =  new ArrayList<VisitableBuilder<? extends BuildTriggerPolicy,?>>();

    public BuildConfigSpecFluentImpl(){
    }
    public BuildConfigSpecFluentImpl(BuildConfigSpec instance){
            this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
            this.withOutput(instance.getOutput()); 
            this.withPostCommit(instance.getPostCommit()); 
            this.withResources(instance.getResources()); 
            this.withRevision(instance.getRevision()); 
            this.withRunPolicy(instance.getRunPolicy()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withSource(instance.getSource()); 
            this.withStrategy(instance.getStrategy()); 
            this.withTriggers(instance.getTriggers()); 
    }

    public Long getCompletionDeadlineSeconds(){
            return this.completionDeadlineSeconds;
    }

    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds){
            this.completionDeadlineSeconds=completionDeadlineSeconds; return (A) this;
    }

    public BuildOutput getOutput(){
            return this.output!=null?this.output.build():null;
    }

    public A withOutput(BuildOutput output){
            _visitables.remove(this.output);
            if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.add(this.output);} return (A) this;
    }

    public BuildConfigSpecFluent.OutputNested<A> withNewOutput(){
            return new OutputNestedImpl();
    }

    public BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item){
            return new OutputNestedImpl(item);
    }

    public BuildConfigSpecFluent.OutputNested<A> editOutput(){
            return withNewOutputLike(getOutput());
    }

    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutput(){
            return withNewOutputLike(getOutput() != null ? getOutput(): new BuildOutputBuilder().build());
    }

    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item){
            return withNewOutputLike(getOutput() != null ? getOutput(): item);
    }

    public BuildPostCommitSpec getPostCommit(){
            return this.postCommit!=null?this.postCommit.build():null;
    }

    public A withPostCommit(BuildPostCommitSpec postCommit){
            _visitables.remove(this.postCommit);
            if (postCommit!=null){ this.postCommit= new BuildPostCommitSpecBuilder(postCommit); _visitables.add(this.postCommit);} return (A) this;
    }

    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit(){
            return new PostCommitNestedImpl();
    }

    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item){
            return new PostCommitNestedImpl(item);
    }

    public BuildConfigSpecFluent.PostCommitNested<A> editPostCommit(){
            return withNewPostCommitLike(getPostCommit());
    }

    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit(){
            return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): new BuildPostCommitSpecBuilder().build());
    }

    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item){
            return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): item);
    }

    public ResourceRequirements getResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources){
            _visitables.remove(this.resources);
            if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (A) this;
    }

    public BuildConfigSpecFluent.ResourcesNested<A> withNewResources(){
            return new ResourcesNestedImpl();
    }

    public BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item){
            return new ResourcesNestedImpl(item);
    }

    public BuildConfigSpecFluent.ResourcesNested<A> editResources(){
            return withNewResourcesLike(getResources());
    }

    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources(){
            return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
    }

    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item){
            return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public SourceRevision getRevision(){
            return this.revision!=null?this.revision.build():null;
    }

    public A withRevision(SourceRevision revision){
            _visitables.remove(this.revision);
            if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (A) this;
    }

    public BuildConfigSpecFluent.RevisionNested<A> withNewRevision(){
            return new RevisionNestedImpl();
    }

    public BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item){
            return new RevisionNestedImpl(item);
    }

    public BuildConfigSpecFluent.RevisionNested<A> editRevision(){
            return withNewRevisionLike(getRevision());
    }

    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision(){
            return withNewRevisionLike(getRevision() != null ? getRevision(): new SourceRevisionBuilder().build());
    }

    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item){
            return withNewRevisionLike(getRevision() != null ? getRevision(): item);
    }

    public String getRunPolicy(){
            return this.runPolicy;
    }

    public A withRunPolicy(String runPolicy){
            this.runPolicy=runPolicy; return (A) this;
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public BuildSource getSource(){
            return this.source!=null?this.source.build():null;
    }

    public A withSource(BuildSource source){
            _visitables.remove(this.source);
            if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.add(this.source);} return (A) this;
    }

    public BuildConfigSpecFluent.SourceNested<A> withNewSource(){
            return new SourceNestedImpl();
    }

    public BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item){
            return new SourceNestedImpl(item);
    }

    public BuildConfigSpecFluent.SourceNested<A> editSource(){
            return withNewSourceLike(getSource());
    }

    public BuildConfigSpecFluent.SourceNested<A> editOrNewSource(){
            return withNewSourceLike(getSource() != null ? getSource(): new BuildSourceBuilder().build());
    }

    public BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item){
            return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    public BuildStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(BuildStrategy strategy){
            _visitables.remove(this.strategy);
            if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }

    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item){
            return new StrategyNestedImpl(item);
    }

    public BuildConfigSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new BuildStrategyBuilder().build());
    }

    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    public A addToTriggers(BuildTriggerPolicy... items){
            for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A removeFromTriggers(BuildTriggerPolicy... items){
            for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.remove(builder);this.triggers.remove(builder);} return (A)this;
    }

    public List<BuildTriggerPolicy> getTriggers(){
            return build(triggers);
    }

    public A withTriggers(List<BuildTriggerPolicy> triggers){
            _visitables.removeAll(this.triggers);
            this.triggers.clear();
            if (triggers != null) {for (BuildTriggerPolicy item : triggers){this.addToTriggers(item);}} return (A) this;
    }

    public A withTriggers(BuildTriggerPolicy... triggers){
            this.triggers.clear(); if (triggers != null) {for (BuildTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
    }

    public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger(){
            return new TriggersNestedImpl();
    }

    public BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item){
            return new TriggersNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl) o;
            if (completionDeadlineSeconds != null ? !completionDeadlineSeconds.equals(that.completionDeadlineSeconds) :that.completionDeadlineSeconds != null) return false;
            if (output != null ? !output.equals(that.output) :that.output != null) return false;
            if (postCommit != null ? !postCommit.equals(that.postCommit) :that.postCommit != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
            if (runPolicy != null ? !runPolicy.equals(that.runPolicy) :that.runPolicy != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
            return true;
    }


    public class OutputNestedImpl<N> extends BuildOutputFluentImpl<BuildConfigSpecFluent.OutputNested<N>> implements BuildConfigSpecFluent.OutputNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildOutputBuilder builder;
    
            OutputNestedImpl(BuildOutput item){
                    this.builder = new BuildOutputBuilder(this, item);
            }
            OutputNestedImpl(){
                    this.builder = new BuildOutputBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withOutput(builder.build());
    }
    public N endOutput(){
            return and();
    }

}
    public class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<BuildConfigSpecFluent.PostCommitNested<N>> implements BuildConfigSpecFluent.PostCommitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildPostCommitSpecBuilder builder;
    
            PostCommitNestedImpl(BuildPostCommitSpec item){
                    this.builder = new BuildPostCommitSpecBuilder(this, item);
            }
            PostCommitNestedImpl(){
                    this.builder = new BuildPostCommitSpecBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withPostCommit(builder.build());
    }
    public N endPostCommit(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<BuildConfigSpecFluent.ResourcesNested<N>> implements BuildConfigSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceRequirementsBuilder builder;
    
            ResourcesNestedImpl(ResourceRequirements item){
                    this.builder = new ResourceRequirementsBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.builder = new ResourceRequirementsBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources(){
            return and();
    }

}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildConfigSpecFluent.RevisionNested<N>> implements BuildConfigSpecFluent.RevisionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SourceRevisionBuilder builder;
    
            RevisionNestedImpl(SourceRevision item){
                    this.builder = new SourceRevisionBuilder(this, item);
            }
            RevisionNestedImpl(){
                    this.builder = new SourceRevisionBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision(){
            return and();
    }

}
    public class SourceNestedImpl<N> extends BuildSourceFluentImpl<BuildConfigSpecFluent.SourceNested<N>> implements BuildConfigSpecFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildSourceBuilder builder;
    
            SourceNestedImpl(BuildSource item){
                    this.builder = new BuildSourceBuilder(this, item);
            }
            SourceNestedImpl(){
                    this.builder = new BuildSourceBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<BuildConfigSpecFluent.StrategyNested<N>> implements BuildConfigSpecFluent.StrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildStrategyBuilder builder;
    
            StrategyNestedImpl(BuildStrategy item){
                    this.builder = new BuildStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new BuildStrategyBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TriggersNestedImpl<N> extends BuildTriggerPolicyFluentImpl<BuildConfigSpecFluent.TriggersNested<N>> implements BuildConfigSpecFluent.TriggersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildTriggerPolicyBuilder builder;
    
            TriggersNestedImpl(BuildTriggerPolicy item){
                    this.builder = new BuildTriggerPolicyBuilder(this, item);
            }
            TriggersNestedImpl(){
                    this.builder = new BuildTriggerPolicyBuilder(this);
            }
    
    public N and(){
            return (N) BuildConfigSpecFluentImpl.this.addToTriggers(builder.build());
    }
    public N endTrigger(){
            return and();
    }

}


}
