package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class BuildOutputBuilder extends BuildOutputFluentImpl<BuildOutputBuilder> implements VisitableBuilder<BuildOutput,BuildOutputBuilder>{

    BuildOutputFluent<?> fluent;
    Boolean validationEnabled;

    public BuildOutputBuilder(){
            this(true);
    }
    public BuildOutputBuilder(Boolean validationEnabled){
            this(new BuildOutput(), validationEnabled);
    }
    public BuildOutputBuilder(BuildOutputFluent<?> fluent){
            this(fluent, true);
    }
    public BuildOutputBuilder(BuildOutputFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BuildOutput(), validationEnabled);
    }
    public BuildOutputBuilder(BuildOutputFluent<?> fluent,BuildOutput instance){
            this(fluent, instance, true);
    }
    public BuildOutputBuilder(BuildOutputFluent<?> fluent,BuildOutput instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPushSecret(instance.getPushSecret()); 
            fluent.withTo(instance.getTo()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildOutputBuilder(BuildOutput instance){
            this(instance,true);
    }
    public BuildOutputBuilder(BuildOutput instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPushSecret(instance.getPushSecret()); 
            this.withTo(instance.getTo()); 
            this.validationEnabled = validationEnabled; 
    }

    public BuildOutput build(){
            BuildOutput buildable = new BuildOutput(fluent.getPushSecret(),fluent.getTo());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildOutputBuilder that = (BuildOutputBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
