package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class BuildTriggerCauseBuilder extends BuildTriggerCauseFluentImpl<BuildTriggerCauseBuilder> implements VisitableBuilder<BuildTriggerCause,BuildTriggerCauseBuilder>{

    BuildTriggerCauseFluent<?> fluent;
    Boolean validationEnabled;

    public BuildTriggerCauseBuilder(){
            this(true);
    }
    public BuildTriggerCauseBuilder(Boolean validationEnabled){
            this(new BuildTriggerCause(), validationEnabled);
    }
    public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent){
            this(fluent, true);
    }
    public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BuildTriggerCause(), validationEnabled);
    }
    public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent,BuildTriggerCause instance){
            this(fluent, instance, true);
    }
    public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent,BuildTriggerCause instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGenericWebHook(instance.getGenericWebHook()); 
            fluent.withGithubWebHook(instance.getGithubWebHook()); 
            fluent.withImageChangeBuild(instance.getImageChangeBuild()); 
            fluent.withMessage(instance.getMessage()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildTriggerCauseBuilder(BuildTriggerCause instance){
            this(instance,true);
    }
    public BuildTriggerCauseBuilder(BuildTriggerCause instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGenericWebHook(instance.getGenericWebHook()); 
            this.withGithubWebHook(instance.getGithubWebHook()); 
            this.withImageChangeBuild(instance.getImageChangeBuild()); 
            this.withMessage(instance.getMessage()); 
            this.validationEnabled = validationEnabled; 
    }

    public BuildTriggerCause build(){
            BuildTriggerCause buildable = new BuildTriggerCause(fluent.getGenericWebHook(),fluent.getGithubWebHook(),fluent.getImageChangeBuild(),fluent.getMessage());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildTriggerCauseBuilder that = (BuildTriggerCauseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
