package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class DeploymentConfigSpecFluentImpl<A extends DeploymentConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentConfigSpecFluent<A>{

    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private Map<String,String> selector = new LinkedHashMap<String,String>();
    private VisitableBuilder<? extends io.fabric8.openshift.api.model.DeploymentStrategy,?> strategy;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;
    private Boolean test;
    private List<VisitableBuilder<? extends DeploymentTriggerPolicy,?>> triggers =  new ArrayList<VisitableBuilder<? extends DeploymentTriggerPolicy,?>>();

    public DeploymentConfigSpecFluentImpl(){
    }
    public DeploymentConfigSpecFluentImpl(DeploymentConfigSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds()); 
            this.withPaused(instance.getPaused()); 
            this.withReplicas(instance.getReplicas()); 
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
            this.withSelector(instance.getSelector()); 
            this.withStrategy(instance.getStrategy()); 
            this.withTemplate(instance.getTemplate()); 
            this.withTest(instance.getTest()); 
            this.withTriggers(instance.getTriggers()); 
    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean isPaused(){
            return this.paused;
    }

    public A withPaused(Boolean paused){
            this.paused=paused; return (A) this;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public A addToSelector(String key,String value){
            if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }

    public A addToSelector(Map<String,String> map){
            if(map != null) { this.selector.putAll(map);} return (A)this;
    }

    public A removeFromSelector(String key){
            if(key != null) {this.selector.remove(key);} return (A)this;
    }

    public A removeFromSelector(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.selector.remove(key);}} return (A)this;
    }

    public Map<String,String> getSelector(){
            return this.selector;
    }

    public A withSelector(Map<String,String> selector){
            this.selector.clear();
            if (selector != null) {this.selector.putAll(selector);} return (A) this;
    }

    public io.fabric8.openshift.api.model.DeploymentStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(io.fabric8.openshift.api.model.DeploymentStrategy strategy){
            _visitables.remove(this.strategy);
            if (strategy!=null){ this.strategy= new io.fabric8.openshift.api.model.DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }

    public DeploymentConfigSpecFluent.ModelStrategyNested<A> withNewModelStrategy(){
            return new ModelStrategyNestedImpl();
    }

    public DeploymentConfigSpecFluent.ModelStrategyNested<A> withNewStrategyLike(io.fabric8.openshift.api.model.DeploymentStrategy item){
            return new ModelStrategyNestedImpl(item);
    }

    public DeploymentConfigSpecFluent.ModelStrategyNested<A> editModelStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public DeploymentConfigSpecFluent.ModelStrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new io.fabric8.openshift.api.model.DeploymentStrategyBuilder().build());
    }

    public DeploymentConfigSpecFluent.ModelStrategyNested<A> editOrNewStrategyLike(io.fabric8.openshift.api.model.DeploymentStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public Boolean isTest(){
            return this.test;
    }

    public A withTest(Boolean test){
            this.test=test; return (A) this;
    }

    public A addToTriggers(DeploymentTriggerPolicy... items){
            for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A removeFromTriggers(DeploymentTriggerPolicy... items){
            for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.remove(builder);this.triggers.remove(builder);} return (A)this;
    }

    public List<DeploymentTriggerPolicy> getTriggers(){
            return build(triggers);
    }

    public A withTriggers(List<DeploymentTriggerPolicy> triggers){
            _visitables.removeAll(this.triggers);
            this.triggers.clear();
            if (triggers != null) {for (DeploymentTriggerPolicy item : triggers){this.addToTriggers(item);}} return (A) this;
    }

    public A withTriggers(DeploymentTriggerPolicy... triggers){
            this.triggers.clear(); if (triggers != null) {for (DeploymentTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
    }

    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger(){
            return new TriggersNestedImpl();
    }

    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item){
            return new TriggersNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (test != null ? !test.equals(that.test) :that.test != null) return false;
            if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
            return true;
    }


    public class ModelStrategyNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl<DeploymentConfigSpecFluent.ModelStrategyNested<N>> implements DeploymentConfigSpecFluent.ModelStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.openshift.api.model.DeploymentStrategyBuilder builder;
    
            ModelStrategyNestedImpl(io.fabric8.openshift.api.model.DeploymentStrategy item){
                    this.builder = new io.fabric8.openshift.api.model.DeploymentStrategyBuilder(this, item);
            }
            ModelStrategyNestedImpl(){
                    this.builder = new io.fabric8.openshift.api.model.DeploymentStrategyBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConfigSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endModelStrategy(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DeploymentConfigSpecFluent.TemplateNested<N>> implements DeploymentConfigSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConfigSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class TriggersNestedImpl<N> extends DeploymentTriggerPolicyFluentImpl<DeploymentConfigSpecFluent.TriggersNested<N>> implements DeploymentConfigSpecFluent.TriggersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentTriggerPolicyBuilder builder;
    
            TriggersNestedImpl(DeploymentTriggerPolicy item){
                    this.builder = new DeploymentTriggerPolicyBuilder(this, item);
            }
            TriggersNestedImpl(){
                    this.builder = new DeploymentTriggerPolicyBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConfigSpecFluentImpl.this.addToTriggers(builder.build());
    }
    public N endTrigger(){
            return and();
    }

}


}
