package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class DeploymentConfigStatusFluentImpl<A extends DeploymentConfigStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentConfigStatusFluent<A>{

    private Integer availableReplicas;
    private VisitableBuilder<? extends DeploymentDetails,?> details;
    private Long latestVersion;
    private Long observedGeneration;
    private Integer replicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;

    public DeploymentConfigStatusFluentImpl(){
    }
    public DeploymentConfigStatusFluentImpl(DeploymentConfigStatus instance){
            this.withAvailableReplicas(instance.getAvailableReplicas()); 
            this.withDetails(instance.getDetails()); 
            this.withLatestVersion(instance.getLatestVersion()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    }

    public Integer getAvailableReplicas(){
            return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas){
            this.availableReplicas=availableReplicas; return (A) this;
    }

    public DeploymentDetails getDetails(){
            return this.details!=null?this.details.build():null;
    }

    public A withDetails(DeploymentDetails details){
            _visitables.remove(this.details);
            if (details!=null){ this.details= new DeploymentDetailsBuilder(details); _visitables.add(this.details);} return (A) this;
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails(){
            return new DetailsNestedImpl();
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item){
            return new DetailsNestedImpl(item);
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> editDetails(){
            return withNewDetailsLike(getDetails());
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails(){
            return withNewDetailsLike(getDetails() != null ? getDetails(): new DeploymentDetailsBuilder().build());
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item){
            return withNewDetailsLike(getDetails() != null ? getDetails(): item);
    }

    public Long getLatestVersion(){
            return this.latestVersion;
    }

    public A withLatestVersion(Long latestVersion){
            this.latestVersion=latestVersion; return (A) this;
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Integer getUnavailableReplicas(){
            return this.unavailableReplicas;
    }

    public A withUnavailableReplicas(Integer unavailableReplicas){
            this.unavailableReplicas=unavailableReplicas; return (A) this;
    }

    public Integer getUpdatedReplicas(){
            return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas){
            this.updatedReplicas=updatedReplicas; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl) o;
            if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
            if (details != null ? !details.equals(that.details) :that.details != null) return false;
            if (latestVersion != null ? !latestVersion.equals(that.latestVersion) :that.latestVersion != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
            if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
            return true;
    }


    public class DetailsNestedImpl<N> extends DeploymentDetailsFluentImpl<DeploymentConfigStatusFluent.DetailsNested<N>> implements DeploymentConfigStatusFluent.DetailsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentDetailsBuilder builder;
    
            DetailsNestedImpl(DeploymentDetails item){
                    this.builder = new DeploymentDetailsBuilder(this, item);
            }
            DetailsNestedImpl(){
                    this.builder = new DeploymentDetailsBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConfigStatusFluentImpl.this.withDetails(builder.build());
    }
    public N endDetails(){
            return and();
    }

}


}
