package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import lombok.ToString;

public class DeploymentTriggerImageChangeParamsFluentImpl<A extends DeploymentTriggerImageChangeParamsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentTriggerImageChangeParamsFluent<A>{

    private Boolean automatic;
    private List<String> containerNames = new ArrayList<String>();
    private VisitableBuilder<? extends ObjectReference,?> from;
    private String lastTriggeredImage;

    public DeploymentTriggerImageChangeParamsFluentImpl(){
    }
    public DeploymentTriggerImageChangeParamsFluentImpl(DeploymentTriggerImageChangeParams instance){
            this.withAutomatic(instance.getAutomatic()); 
            this.withContainerNames(instance.getContainerNames()); 
            this.withFrom(instance.getFrom()); 
            this.withLastTriggeredImage(instance.getLastTriggeredImage()); 
    }

    public Boolean isAutomatic(){
            return this.automatic;
    }

    public A withAutomatic(Boolean automatic){
            this.automatic=automatic; return (A) this;
    }

    public A addToContainerNames(String... items){
            for (String item : items) {this.containerNames.add(item);} return (A)this;
    }

    public A removeFromContainerNames(String... items){
            for (String item : items) {this.containerNames.remove(item);} return (A)this;
    }

    public List<String> getContainerNames(){
            return this.containerNames;
    }

    public A withContainerNames(List<String> containerNames){
            this.containerNames.clear();
            if (containerNames != null) {for (String item : containerNames){this.addToContainerNames(item);}} return (A) this;
    }

    public A withContainerNames(String... containerNames){
            this.containerNames.clear(); if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            _visitables.remove(this.from);
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFrom(){
            return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFromLike(ObjectReference item){
            return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public String getLastTriggeredImage(){
            return this.lastTriggeredImage;
    }

    public A withLastTriggeredImage(String lastTriggeredImage){
            this.lastTriggeredImage=lastTriggeredImage; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentTriggerImageChangeParamsFluentImpl that = (DeploymentTriggerImageChangeParamsFluentImpl) o;
            if (automatic != null ? !automatic.equals(that.automatic) :that.automatic != null) return false;
            if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (lastTriggeredImage != null ? !lastTriggeredImage.equals(that.lastTriggeredImage) :that.lastTriggeredImage != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<DeploymentTriggerImageChangeParamsFluent.FromNested<N>> implements DeploymentTriggerImageChangeParamsFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentTriggerImageChangeParamsFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom(){
            return and();
    }

}


}
