package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.lang.Object;
import lombok.ToString;

public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DockerBuildStrategyFluent<A>{

    private String dockerfilePath;
    private List<VisitableBuilder<? extends EnvVar,?>> env =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private Boolean forcePull;
    private VisitableBuilder<? extends ObjectReference,?> from;
    private Boolean noCache;
    private VisitableBuilder<? extends LocalObjectReference,?> pullSecret;

    public DockerBuildStrategyFluentImpl(){
    }
    public DockerBuildStrategyFluentImpl(DockerBuildStrategy instance){
            this.withDockerfilePath(instance.getDockerfilePath()); 
            this.withEnv(instance.getEnv()); 
            this.withForcePull(instance.getForcePull()); 
            this.withFrom(instance.getFrom()); 
            this.withNoCache(instance.getNoCache()); 
            this.withPullSecret(instance.getPullSecret()); 
    }

    public String getDockerfilePath(){
            return this.dockerfilePath;
    }

    public A withDockerfilePath(String dockerfilePath){
            this.dockerfilePath=dockerfilePath; return (A) this;
    }

    public A addToEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return build(env);
    }

    public A withEnv(List<EnvVar> env){
            _visitables.removeAll(this.env);
            this.env.clear();
            if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(EnvVar... env){
            this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public DockerBuildStrategyFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public DockerBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item){
            return new EnvNestedImpl(item);
    }

    public Boolean isForcePull(){
            return this.forcePull;
    }

    public A withForcePull(Boolean forcePull){
            this.forcePull=forcePull; return (A) this;
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            _visitables.remove(this.from);
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public DockerBuildStrategyFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public DockerBuildStrategyFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom(){
            return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item){
            return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public Boolean isNoCache(){
            return this.noCache;
    }

    public A withNoCache(Boolean noCache){
            this.noCache=noCache; return (A) this;
    }

    public LocalObjectReference getPullSecret(){
            return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(LocalObjectReference pullSecret){
            _visitables.remove(this.pullSecret);
            if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (A) this;
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret(){
            return new PullSecretNestedImpl();
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item){
            return new PullSecretNestedImpl(item);
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret(){
            return withNewPullSecretLike(getPullSecret());
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret(){
            return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item){
            return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public A withNewPullSecret(String name){
            return (A)withPullSecret(new LocalObjectReference(name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl) o;
            if (dockerfilePath != null ? !dockerfilePath.equals(that.dockerfilePath) :that.dockerfilePath != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (noCache != null ? !noCache.equals(that.noCache) :that.noCache != null) return false;
            if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends EnvVarFluentImpl<DockerBuildStrategyFluent.EnvNested<N>> implements DockerBuildStrategyFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N and(){
            return (N) DockerBuildStrategyFluentImpl.this.addToEnv(builder.build());
    }
    public N endEnv(){
            return and();
    }

}
    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<DockerBuildStrategyFluent.FromNested<N>> implements DockerBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) DockerBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom(){
            return and();
    }

}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluent.PullSecretNested<N>> implements DockerBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            PullSecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
            PullSecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) DockerBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret(){
            return and();
    }

}


}
