package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DockerImageBuilder extends DockerImageFluentImpl<DockerImageBuilder> implements VisitableBuilder<DockerImage,DockerImageBuilder>{

    DockerImageFluent<?> fluent;
    Boolean validationEnabled;

    public DockerImageBuilder(){
            this(true);
    }
    public DockerImageBuilder(Boolean validationEnabled){
            this(new DockerImage(), validationEnabled);
    }
    public DockerImageBuilder(DockerImageFluent<?> fluent){
            this(fluent, true);
    }
    public DockerImageBuilder(DockerImageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerImage(), validationEnabled);
    }
    public DockerImageBuilder(DockerImageFluent<?> fluent,DockerImage instance){
            this(fluent, instance, true);
    }
    public DockerImageBuilder(DockerImageFluent<?> fluent,DockerImage instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withArchitecture(instance.getArchitecture()); 
            fluent.withAuthor(instance.getAuthor()); 
            fluent.withComment(instance.getComment()); 
            fluent.withConfig(instance.getConfig()); 
            fluent.withContainer(instance.getContainer()); 
            fluent.withContainerConfig(instance.getContainerConfig()); 
            fluent.withCreated(instance.getCreated()); 
            fluent.withDockerVersion(instance.getDockerVersion()); 
            fluent.withId(instance.getId()); 
            fluent.withParent(instance.getParent()); 
            fluent.withSize(instance.getSize()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            this.validationEnabled = validationEnabled; 
    }
    public DockerImageBuilder(DockerImage instance){
            this(instance,true);
    }
    public DockerImageBuilder(DockerImage instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withArchitecture(instance.getArchitecture()); 
            this.withAuthor(instance.getAuthor()); 
            this.withComment(instance.getComment()); 
            this.withConfig(instance.getConfig()); 
            this.withContainer(instance.getContainer()); 
            this.withContainerConfig(instance.getContainerConfig()); 
            this.withCreated(instance.getCreated()); 
            this.withDockerVersion(instance.getDockerVersion()); 
            this.withId(instance.getId()); 
            this.withParent(instance.getParent()); 
            this.withSize(instance.getSize()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.validationEnabled = validationEnabled; 
    }

    public DockerImage build(){
            DockerImage buildable = new DockerImage(fluent.getArchitecture(),fluent.getAuthor(),fluent.getComment(),fluent.getConfig(),fluent.getContainer(),fluent.getContainerConfig(),fluent.getCreated(),fluent.getDockerVersion(),fluent.getId(),fluent.getParent(),fluent.getSize(),fluent.getApiVersion(),fluent.getKind());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerImageBuilder that = (DockerImageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
