package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ImageStreamSpecFluentImpl<A extends ImageStreamSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageStreamSpecFluent<A>{

    private String dockerImageRepository;
    private List<VisitableBuilder<? extends TagReference,?>> tags =  new ArrayList<VisitableBuilder<? extends TagReference,?>>();

    public ImageStreamSpecFluentImpl(){
    }
    public ImageStreamSpecFluentImpl(ImageStreamSpec instance){
            this.withDockerImageRepository(instance.getDockerImageRepository()); 
            this.withTags(instance.getTags()); 
    }

    public String getDockerImageRepository(){
            return this.dockerImageRepository;
    }

    public A withDockerImageRepository(String dockerImageRepository){
            this.dockerImageRepository=dockerImageRepository; return (A) this;
    }

    public A addToTags(TagReference... items){
            for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (A)this;
    }

    public A removeFromTags(TagReference... items){
            for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.remove(builder);this.tags.remove(builder);} return (A)this;
    }

    public List<TagReference> getTags(){
            return build(tags);
    }

    public A withTags(List<TagReference> tags){
            _visitables.removeAll(this.tags);
            this.tags.clear();
            if (tags != null) {for (TagReference item : tags){this.addToTags(item);}} return (A) this;
    }

    public A withTags(TagReference... tags){
            this.tags.clear(); if (tags != null) {for (TagReference item :tags){ this.addToTags(item);}} return (A) this;
    }

    public ImageStreamSpecFluent.TagsNested<A> addNewTag(){
            return new TagsNestedImpl();
    }

    public ImageStreamSpecFluent.TagsNested<A> addNewTagLike(TagReference item){
            return new TagsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl) o;
            if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
            if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
            return true;
    }


    public class TagsNestedImpl<N> extends TagReferenceFluentImpl<ImageStreamSpecFluent.TagsNested<N>> implements ImageStreamSpecFluent.TagsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TagReferenceBuilder builder;
    
            TagsNestedImpl(TagReference item){
                    this.builder = new TagReferenceBuilder(this, item);
            }
            TagsNestedImpl(){
                    this.builder = new TagReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ImageStreamSpecFluentImpl.this.addToTags(builder.build());
    }
    public N endTag(){
            return and();
    }

}


}
