package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ImageStreamTagBuilder extends ImageStreamTagFluentImpl<ImageStreamTagBuilder> implements VisitableBuilder<ImageStreamTag,ImageStreamTagBuilder>{

    ImageStreamTagFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamTagBuilder(){
            this(true);
    }
    public ImageStreamTagBuilder(Boolean validationEnabled){
            this(new ImageStreamTag(), validationEnabled);
    }
    public ImageStreamTagBuilder(ImageStreamTagFluent<?> fluent){
            this(fluent, true);
    }
    public ImageStreamTagBuilder(ImageStreamTagFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageStreamTag(), validationEnabled);
    }
    public ImageStreamTagBuilder(ImageStreamTagFluent<?> fluent,ImageStreamTag instance){
            this(fluent, instance, true);
    }
    public ImageStreamTagBuilder(ImageStreamTagFluent<?> fluent,ImageStreamTag instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withImage(instance.getImage()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withTag(instance.getTag()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageStreamTagBuilder(ImageStreamTag instance){
            this(instance,true);
    }
    public ImageStreamTagBuilder(ImageStreamTag instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withConditions(instance.getConditions()); 
            this.withGeneration(instance.getGeneration()); 
            this.withImage(instance.getImage()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withTag(instance.getTag()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageStreamTag build(){
            ImageStreamTag buildable = new ImageStreamTag(fluent.getApiVersion(),fluent.getConditions(),fluent.getGeneration(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getTag());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamTagBuilder that = (ImageStreamTagBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
