package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class CinderVolumeSourceBuilder extends CinderVolumeSourceFluentImpl<CinderVolumeSourceBuilder> implements VisitableBuilder<CinderVolumeSource,CinderVolumeSourceBuilder>{

    CinderVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CinderVolumeSourceBuilder(){
            this(true);
    }
    public CinderVolumeSourceBuilder(Boolean validationEnabled){
            this(new CinderVolumeSource(), validationEnabled);
    }
    public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CinderVolumeSource(), validationEnabled);
    }
    public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent,CinderVolumeSource instance){
            this(fluent, instance, true);
    }
    public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent,CinderVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsType(instance.getFsType()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            fluent.withVolumeID(instance.getVolumeID()); 
            this.validationEnabled = validationEnabled; 
    }
    public CinderVolumeSourceBuilder(CinderVolumeSource instance){
            this(instance,true);
    }
    public CinderVolumeSourceBuilder(CinderVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsType(instance.getFsType()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withVolumeID(instance.getVolumeID()); 
            this.validationEnabled = validationEnabled; 
    }

    public CinderVolumeSource build(){
            CinderVolumeSource buildable = new CinderVolumeSource(fluent.getFsType(),fluent.isReadOnly(),fluent.getVolumeID());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CinderVolumeSourceBuilder that = (CinderVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
