package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ConfigMapVolumeSourceFluentImpl<A extends ConfigMapVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConfigMapVolumeSourceFluent<A>{

    private List<VisitableBuilder<? extends KeyToPath,?>> items =  new ArrayList<VisitableBuilder<? extends KeyToPath,?>>();
    private String name;

    public ConfigMapVolumeSourceFluentImpl(){
    }
    public ConfigMapVolumeSourceFluentImpl(ConfigMapVolumeSource instance){
            this.withItems(instance.getItems()); 
            this.withName(instance.getName()); 
    }

    public A addToItems(KeyToPath... items){
            for (KeyToPath item : items) {KeyToPathBuilder builder = new KeyToPathBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(KeyToPath... items){
            for (KeyToPath item : items) {KeyToPathBuilder builder = new KeyToPathBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<KeyToPath> getItems(){
            return build(items);
    }

    public A withItems(List<KeyToPath> items){
            _visitables.removeAll(this.items);
            this.items.clear();
            if (items != null) {for (KeyToPath item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(KeyToPath... items){
            this.items.clear(); if (items != null) {for (KeyToPath item :items){ this.addToItems(item);}} return (A) this;
    }

    public ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item){
            return new ItemsNestedImpl(item);
    }

    public A addNewItem(String key,String path){
            return (A)addToItems(new KeyToPath(key, path));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigMapVolumeSourceFluentImpl that = (ConfigMapVolumeSourceFluentImpl) o;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends KeyToPathFluentImpl<ConfigMapVolumeSourceFluent.ItemsNested<N>> implements ConfigMapVolumeSourceFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KeyToPathBuilder builder;
    
            ItemsNestedImpl(KeyToPath item){
                    this.builder = new KeyToPathBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new KeyToPathBuilder(this);
            }
    
    public N and(){
            return (N) ConfigMapVolumeSourceFluentImpl.this.addToItems(builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
