package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import io.sundr.builder.annotations.Buildable;
import com.fasterxml.jackson.core.JsonParser;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface HTTPGetActionFluent<A extends HTTPGetActionFluent<A>> extends Fluent<A>{


    public String getHost();
    public A withHost(String host);
    public A addToHttpHeaders(HTTPHeader... items);
    public A removeFromHttpHeaders(HTTPHeader... items);
    public List<HTTPHeader> getHttpHeaders();
    public A withHttpHeaders(List<HTTPHeader> httpHeaders);
    public A withHttpHeaders(HTTPHeader... httpHeaders);
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader();
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item);
    public A addNewHttpHeader(String name,String value);
    public String getPath();
    public A withPath(String path);
    public IntOrString getPort();
    public A withPort(IntOrString port);
    public HTTPGetActionFluent.PortNested<A> withNewPort();
    public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item);
    public HTTPGetActionFluent.PortNested<A> editPort();
    public HTTPGetActionFluent.PortNested<A> editOrNewPort();
    public HTTPGetActionFluent.PortNested<A> editOrNewPortLike(IntOrString item);
    public A withNewPort(Integer intVal);
    public A withNewPort(String strVal);
    public String getScheme();
    public A withScheme(String scheme);

    public interface HttpHeadersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPHeaderFluent<HTTPGetActionFluent.HttpHeadersNested<N>>{

        
    public N and();    public N endHttpHeader();
}
    public interface PortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntOrStringFluent<HTTPGetActionFluent.PortNested<N>>{

        
    public N and();    public N endPort();
}


}
