package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class LabelSelectorRequirementFluentImpl<A extends LabelSelectorRequirementFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LabelSelectorRequirementFluent<A>{

    private String key;
    private String operator;
    private List<String> values = new ArrayList<String>();

    public LabelSelectorRequirementFluentImpl(){
    }
    public LabelSelectorRequirementFluentImpl(LabelSelectorRequirement instance){
            this.withKey(instance.getKey()); 
            this.withOperator(instance.getOperator()); 
            this.withValues(instance.getValues()); 
    }

    public String getKey(){
            return this.key;
    }

    public A withKey(String key){
            this.key=key; return (A) this;
    }

    public String getOperator(){
            return this.operator;
    }

    public A withOperator(String operator){
            this.operator=operator; return (A) this;
    }

    public A addToValues(String... items){
            for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A removeFromValues(String... items){
            for (String item : items) {this.values.remove(item);} return (A)this;
    }

    public List<String> getValues(){
            return this.values;
    }

    public A withValues(List<String> values){
            this.values.clear();
            if (values != null) {for (String item : values){this.addToValues(item);}} return (A) this;
    }

    public A withValues(String... values){
            this.values.clear(); if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LabelSelectorRequirementFluentImpl that = (LabelSelectorRequirementFluentImpl) o;
            if (key != null ? !key.equals(that.key) :that.key != null) return false;
            if (operator != null ? !operator.equals(that.operator) :that.operator != null) return false;
            if (values != null ? !values.equals(that.values) :that.values != null) return false;
            return true;
    }




}
