package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NamedAuthInfoBuilder extends NamedAuthInfoFluentImpl<NamedAuthInfoBuilder> implements VisitableBuilder<NamedAuthInfo,NamedAuthInfoBuilder>{

    NamedAuthInfoFluent<?> fluent;
    Boolean validationEnabled;

    public NamedAuthInfoBuilder(){
            this(true);
    }
    public NamedAuthInfoBuilder(Boolean validationEnabled){
            this(new NamedAuthInfo(), validationEnabled);
    }
    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent){
            this(fluent, true);
    }
    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamedAuthInfo(), validationEnabled);
    }
    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent,NamedAuthInfo instance){
            this(fluent, instance, true);
    }
    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent,NamedAuthInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedAuthInfoBuilder(NamedAuthInfo instance){
            this(instance,true);
    }
    public NamedAuthInfoBuilder(NamedAuthInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public NamedAuthInfo build(){
            NamedAuthInfo buildable = new NamedAuthInfo(fluent.getName(),fluent.getUser());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedAuthInfoBuilder that = (NamedAuthInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
