package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface NamespaceFluent<A extends NamespaceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public NamespaceFluent.MetadataNested<A> withNewMetadata();
    public NamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NamespaceFluent.MetadataNested<A> editMetadata();
    public NamespaceFluent.MetadataNested<A> editOrNewMetadata();
    public NamespaceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public NamespaceSpec getSpec();
    public A withSpec(NamespaceSpec spec);
    public NamespaceFluent.SpecNested<A> withNewSpec();
    public NamespaceFluent.SpecNested<A> withNewSpecLike(NamespaceSpec item);
    public NamespaceFluent.SpecNested<A> editSpec();
    public NamespaceFluent.SpecNested<A> editOrNewSpec();
    public NamespaceFluent.SpecNested<A> editOrNewSpecLike(NamespaceSpec item);
    public NamespaceStatus getStatus();
    public A withStatus(NamespaceStatus status);
    public NamespaceFluent.StatusNested<A> withNewStatus();
    public NamespaceFluent.StatusNested<A> withNewStatusLike(NamespaceStatus item);
    public NamespaceFluent.StatusNested<A> editStatus();
    public NamespaceFluent.StatusNested<A> editOrNewStatus();
    public NamespaceFluent.StatusNested<A> editOrNewStatusLike(NamespaceStatus item);
    public A withNewStatus(String phase);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<NamespaceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceSpecFluent<NamespaceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceStatusFluent<NamespaceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
