package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import lombok.EqualsAndHashCode;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.ToString;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeStatusFluent<A>{

    private List<VisitableBuilder<? extends NodeAddress,?>> addresses =  new ArrayList<VisitableBuilder<? extends NodeAddress,?>>();
    private Map<String,Quantity> allocatable = new LinkedHashMap<String,Quantity>();
    private Map<String,Quantity> capacity = new LinkedHashMap<String,Quantity>();
    private List<VisitableBuilder<? extends NodeCondition,?>> conditions =  new ArrayList<VisitableBuilder<? extends NodeCondition,?>>();
    private VisitableBuilder<? extends NodeDaemonEndpoints,?> daemonEndpoints;
    private List<VisitableBuilder<? extends ContainerImage,?>> images =  new ArrayList<VisitableBuilder<? extends ContainerImage,?>>();
    private VisitableBuilder<? extends NodeSystemInfo,?> nodeInfo;
    private String phase;
    private List<VisitableBuilder<? extends AttachedVolume,?>> volumesAttached =  new ArrayList<VisitableBuilder<? extends AttachedVolume,?>>();
    private List<String> volumesInUse = new ArrayList<String>();

    public NodeStatusFluentImpl(){
    }
    public NodeStatusFluentImpl(NodeStatus instance){
            this.withAddresses(instance.getAddresses()); 
            this.withAllocatable(instance.getAllocatable()); 
            this.withCapacity(instance.getCapacity()); 
            this.withConditions(instance.getConditions()); 
            this.withDaemonEndpoints(instance.getDaemonEndpoints()); 
            this.withImages(instance.getImages()); 
            this.withNodeInfo(instance.getNodeInfo()); 
            this.withPhase(instance.getPhase()); 
            this.withVolumesAttached(instance.getVolumesAttached()); 
            this.withVolumesInUse(instance.getVolumesInUse()); 
    }

    public A addToAddresses(NodeAddress... items){
            for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(NodeAddress... items){
            for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.remove(builder);this.addresses.remove(builder);} return (A)this;
    }

    public List<NodeAddress> getAddresses(){
            return build(addresses);
    }

    public A withAddresses(List<NodeAddress> addresses){
            _visitables.removeAll(this.addresses);
            this.addresses.clear();
            if (addresses != null) {for (NodeAddress item : addresses){this.addToAddresses(item);}} return (A) this;
    }

    public A withAddresses(NodeAddress... addresses){
            this.addresses.clear(); if (addresses != null) {for (NodeAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public NodeStatusFluent.AddressesNested<A> addNewAddress(){
            return new AddressesNestedImpl();
    }

    public NodeStatusFluent.AddressesNested<A> addNewAddressLike(NodeAddress item){
            return new AddressesNestedImpl(item);
    }

    public A addNewAddress(String address,String type){
            return (A)addToAddresses(new NodeAddress(address, type));
    }

    public A addToAllocatable(String key,Quantity value){
            if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
    }

    public A addToAllocatable(Map<String,Quantity> map){
            if(map != null) { this.allocatable.putAll(map);} return (A)this;
    }

    public A removeFromAllocatable(String key){
            if(key != null) {this.allocatable.remove(key);} return (A)this;
    }

    public A removeFromAllocatable(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.allocatable.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getAllocatable(){
            return this.allocatable;
    }

    public A withAllocatable(Map<String,Quantity> allocatable){
            this.allocatable.clear();
            if (allocatable != null) {this.allocatable.putAll(allocatable);} return (A) this;
    }

    public A addToCapacity(String key,Quantity value){
            if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
    }

    public A addToCapacity(Map<String,Quantity> map){
            if(map != null) { this.capacity.putAll(map);} return (A)this;
    }

    public A removeFromCapacity(String key){
            if(key != null) {this.capacity.remove(key);} return (A)this;
    }

    public A removeFromCapacity(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getCapacity(){
            return this.capacity;
    }

    public A withCapacity(Map<String,Quantity> capacity){
            this.capacity.clear();
            if (capacity != null) {this.capacity.putAll(capacity);} return (A) this;
    }

    public A addToConditions(NodeCondition... items){
            for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(NodeCondition... items){
            for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }

    public List<NodeCondition> getConditions(){
            return build(conditions);
    }

    public A withConditions(List<NodeCondition> conditions){
            _visitables.removeAll(this.conditions);
            this.conditions.clear();
            if (conditions != null) {for (NodeCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }

    public A withConditions(NodeCondition... conditions){
            this.conditions.clear(); if (conditions != null) {for (NodeCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public NodeStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item){
            return new ConditionsNestedImpl(item);
    }

    public NodeDaemonEndpoints getDaemonEndpoints(){
            return this.daemonEndpoints!=null?this.daemonEndpoints.build():null;
    }

    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints){
            _visitables.remove(this.daemonEndpoints);
            if (daemonEndpoints!=null){ this.daemonEndpoints= new NodeDaemonEndpointsBuilder(daemonEndpoints); _visitables.add(this.daemonEndpoints);} return (A) this;
    }

    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints(){
            return new DaemonEndpointsNestedImpl();
    }

    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item){
            return new DaemonEndpointsNestedImpl(item);
    }

    public NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints(){
            return withNewDaemonEndpointsLike(getDaemonEndpoints());
    }

    public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints(){
            return withNewDaemonEndpointsLike(getDaemonEndpoints() != null ? getDaemonEndpoints(): new NodeDaemonEndpointsBuilder().build());
    }

    public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item){
            return withNewDaemonEndpointsLike(getDaemonEndpoints() != null ? getDaemonEndpoints(): item);
    }

    public A addToImages(ContainerImage... items){
            for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.add(builder);this.images.add(builder);} return (A)this;
    }

    public A removeFromImages(ContainerImage... items){
            for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.remove(builder);this.images.remove(builder);} return (A)this;
    }

    public List<ContainerImage> getImages(){
            return build(images);
    }

    public A withImages(List<ContainerImage> images){
            _visitables.removeAll(this.images);
            this.images.clear();
            if (images != null) {for (ContainerImage item : images){this.addToImages(item);}} return (A) this;
    }

    public A withImages(ContainerImage... images){
            this.images.clear(); if (images != null) {for (ContainerImage item :images){ this.addToImages(item);}} return (A) this;
    }

    public NodeStatusFluent.ImagesNested<A> addNewImage(){
            return new ImagesNestedImpl();
    }

    public NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item){
            return new ImagesNestedImpl(item);
    }

    public NodeSystemInfo getNodeInfo(){
            return this.nodeInfo!=null?this.nodeInfo.build():null;
    }

    public A withNodeInfo(NodeSystemInfo nodeInfo){
            _visitables.remove(this.nodeInfo);
            if (nodeInfo!=null){ this.nodeInfo= new NodeSystemInfoBuilder(nodeInfo); _visitables.add(this.nodeInfo);} return (A) this;
    }

    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo(){
            return new NodeInfoNestedImpl();
    }

    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item){
            return new NodeInfoNestedImpl(item);
    }

    public NodeStatusFluent.NodeInfoNested<A> editNodeInfo(){
            return withNewNodeInfoLike(getNodeInfo());
    }

    public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo(){
            return withNewNodeInfoLike(getNodeInfo() != null ? getNodeInfo(): new NodeSystemInfoBuilder().build());
    }

    public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item){
            return withNewNodeInfoLike(getNodeInfo() != null ? getNodeInfo(): item);
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public A addToVolumesAttached(AttachedVolume... items){
            for (AttachedVolume item : items) {AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);_visitables.add(builder);this.volumesAttached.add(builder);} return (A)this;
    }

    public A removeFromVolumesAttached(AttachedVolume... items){
            for (AttachedVolume item : items) {AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);_visitables.remove(builder);this.volumesAttached.remove(builder);} return (A)this;
    }

    public List<AttachedVolume> getVolumesAttached(){
            return build(volumesAttached);
    }

    public A withVolumesAttached(List<AttachedVolume> volumesAttached){
            _visitables.removeAll(this.volumesAttached);
            this.volumesAttached.clear();
            if (volumesAttached != null) {for (AttachedVolume item : volumesAttached){this.addToVolumesAttached(item);}} return (A) this;
    }

    public A withVolumesAttached(AttachedVolume... volumesAttached){
            this.volumesAttached.clear(); if (volumesAttached != null) {for (AttachedVolume item :volumesAttached){ this.addToVolumesAttached(item);}} return (A) this;
    }

    public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached(){
            return new VolumesAttachedNestedImpl();
    }

    public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item){
            return new VolumesAttachedNestedImpl(item);
    }

    public A addNewVolumesAttached(String devicePath,String name){
            return (A)addToVolumesAttached(new AttachedVolume(devicePath, name));
    }

    public A addToVolumesInUse(String... items){
            for (String item : items) {this.volumesInUse.add(item);} return (A)this;
    }

    public A removeFromVolumesInUse(String... items){
            for (String item : items) {this.volumesInUse.remove(item);} return (A)this;
    }

    public List<String> getVolumesInUse(){
            return this.volumesInUse;
    }

    public A withVolumesInUse(List<String> volumesInUse){
            this.volumesInUse.clear();
            if (volumesInUse != null) {for (String item : volumesInUse){this.addToVolumesInUse(item);}} return (A) this;
    }

    public A withVolumesInUse(String... volumesInUse){
            this.volumesInUse.clear(); if (volumesInUse != null) {for (String item :volumesInUse){ this.addToVolumesInUse(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeStatusFluentImpl that = (NodeStatusFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
            if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (daemonEndpoints != null ? !daemonEndpoints.equals(that.daemonEndpoints) :that.daemonEndpoints != null) return false;
            if (images != null ? !images.equals(that.images) :that.images != null) return false;
            if (nodeInfo != null ? !nodeInfo.equals(that.nodeInfo) :that.nodeInfo != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (volumesAttached != null ? !volumesAttached.equals(that.volumesAttached) :that.volumesAttached != null) return false;
            if (volumesInUse != null ? !volumesInUse.equals(that.volumesInUse) :that.volumesInUse != null) return false;
            return true;
    }


    public class AddressesNestedImpl<N> extends NodeAddressFluentImpl<NodeStatusFluent.AddressesNested<N>> implements NodeStatusFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeAddressBuilder builder;
    
            AddressesNestedImpl(NodeAddress item){
                    this.builder = new NodeAddressBuilder(this, item);
            }
            AddressesNestedImpl(){
                    this.builder = new NodeAddressBuilder(this);
            }
    
    public N and(){
            return (N) NodeStatusFluentImpl.this.addToAddresses(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends NodeConditionFluentImpl<NodeStatusFluent.ConditionsNested<N>> implements NodeStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeConditionBuilder builder;
    
            ConditionsNestedImpl(NodeCondition item){
                    this.builder = new NodeConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.builder = new NodeConditionBuilder(this);
            }
    
    public N and(){
            return (N) NodeStatusFluentImpl.this.addToConditions(builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class DaemonEndpointsNestedImpl<N> extends NodeDaemonEndpointsFluentImpl<NodeStatusFluent.DaemonEndpointsNested<N>> implements NodeStatusFluent.DaemonEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeDaemonEndpointsBuilder builder;
    
            DaemonEndpointsNestedImpl(NodeDaemonEndpoints item){
                    this.builder = new NodeDaemonEndpointsBuilder(this, item);
            }
            DaemonEndpointsNestedImpl(){
                    this.builder = new NodeDaemonEndpointsBuilder(this);
            }
    
    public N and(){
            return (N) NodeStatusFluentImpl.this.withDaemonEndpoints(builder.build());
    }
    public N endDaemonEndpoints(){
            return and();
    }

}
    public class ImagesNestedImpl<N> extends ContainerImageFluentImpl<NodeStatusFluent.ImagesNested<N>> implements NodeStatusFluent.ImagesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerImageBuilder builder;
    
            ImagesNestedImpl(ContainerImage item){
                    this.builder = new ContainerImageBuilder(this, item);
            }
            ImagesNestedImpl(){
                    this.builder = new ContainerImageBuilder(this);
            }
    
    public N and(){
            return (N) NodeStatusFluentImpl.this.addToImages(builder.build());
    }
    public N endImage(){
            return and();
    }

}
    public class NodeInfoNestedImpl<N> extends NodeSystemInfoFluentImpl<NodeStatusFluent.NodeInfoNested<N>> implements NodeStatusFluent.NodeInfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeSystemInfoBuilder builder;
    
            NodeInfoNestedImpl(NodeSystemInfo item){
                    this.builder = new NodeSystemInfoBuilder(this, item);
            }
            NodeInfoNestedImpl(){
                    this.builder = new NodeSystemInfoBuilder(this);
            }
    
    public N and(){
            return (N) NodeStatusFluentImpl.this.withNodeInfo(builder.build());
    }
    public N endNodeInfo(){
            return and();
    }

}
    public class VolumesAttachedNestedImpl<N> extends AttachedVolumeFluentImpl<NodeStatusFluent.VolumesAttachedNested<N>> implements NodeStatusFluent.VolumesAttachedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AttachedVolumeBuilder builder;
    
            VolumesAttachedNestedImpl(AttachedVolume item){
                    this.builder = new AttachedVolumeBuilder(this, item);
            }
            VolumesAttachedNestedImpl(){
                    this.builder = new AttachedVolumeBuilder(this);
            }
    
    public N and(){
            return (N) NodeStatusFluentImpl.this.addToVolumesAttached(builder.build());
    }
    public N endVolumesAttached(){
            return and();
    }

}


}
