package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.validation.constraints.Pattern;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ObjectMetaFluent<A extends ObjectMetaFluent<A>> extends Fluent<A>{


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public String getCreationTimestamp();
    public A withCreationTimestamp(String creationTimestamp);
    public Long getDeletionGracePeriodSeconds();
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds);
    public String getDeletionTimestamp();
    public A withDeletionTimestamp(String deletionTimestamp);
    public A addToFinalizers(String... items);
    public A removeFromFinalizers(String... items);
    public List<String> getFinalizers();
    public A withFinalizers(List<String> finalizers);
    public A withFinalizers(String... finalizers);
    public String getGenerateName();
    public A withGenerateName(String generateName);
    public Long getGeneration();
    public A withGeneration(Long generation);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public String getName();
    public A withName(String name);
    public String getNamespace();
    public A withNamespace(String namespace);
    public A addToOwnerReferences(OwnerReference... items);
    public A removeFromOwnerReferences(OwnerReference... items);
    public List<OwnerReference> getOwnerReferences();
    public A withOwnerReferences(List<OwnerReference> ownerReferences);
    public A withOwnerReferences(OwnerReference... ownerReferences);
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference();
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(OwnerReference item);
    public A addNewOwnerReference(String apiVersion,Boolean controller,String kind,String name,String uid);
    public String getResourceVersion();
    public A withResourceVersion(String resourceVersion);
    public String getSelfLink();
    public A withSelfLink(String selfLink);
    public String getUid();
    public A withUid(String uid);

    public interface OwnerReferencesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OwnerReferenceFluent<ObjectMetaFluent.OwnerReferencesNested<N>>{

        
    public N and();    public N endOwnerReference();
}


}
