package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.String;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import lombok.ToString;

public interface PersistentVolumeSpecFluent<A extends PersistentVolumeSpecFluent<A>> extends Fluent<A>{


    public A addToAccessModes(String... items);
    public A removeFromAccessModes(String... items);
    public List<String> getAccessModes();
    public A withAccessModes(List<String> accessModes);
    public A withAccessModes(String... accessModes);
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore);
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID);
    public AzureFileVolumeSource getAzureFile();
    public A withAzureFile(AzureFileVolumeSource azureFile);
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item);
    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item);
    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public CephFSVolumeSource getCephfs();
    public A withCephfs(CephFSVolumeSource cephfs);
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item);
    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item);
    public CinderVolumeSource getCinder();
    public A withCinder(CinderVolumeSource cinder);
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item);
    public PersistentVolumeSpecFluent.CinderNested<A> editCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item);
    public A withNewCinder(String fsType,Boolean readOnly,String volumeID);
    public ObjectReference getClaimRef();
    public A withClaimRef(ObjectReference claimRef);
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item);
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item);
    public FCVolumeSource getFc();
    public A withFc(FCVolumeSource fc);
    public PersistentVolumeSpecFluent.FcNested<A> withNewFc();
    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item);
    public PersistentVolumeSpecFluent.FcNested<A> editFc();
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFc();
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item);
    public FlexVolumeSource getFlexVolume();
    public A withFlexVolume(FlexVolumeSource flexVolume);
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item);
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item);
    public FlockerVolumeSource getFlocker();
    public A withFlocker(FlockerVolumeSource flocker);
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item);
    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item);
    public A withNewFlocker(String datasetName);
    public GCEPersistentDiskVolumeSource getGcePersistentDisk();
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk);
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly);
    public GlusterfsVolumeSource getGlusterfs();
    public A withGlusterfs(GlusterfsVolumeSource glusterfs);
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item);
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item);
    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly);
    public HostPathVolumeSource getHostPath();
    public A withHostPath(HostPathVolumeSource hostPath);
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item);
    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item);
    public A withNewHostPath(String path);
    public ISCSIVolumeSource getIscsi();
    public A withIscsi(ISCSIVolumeSource iscsi);
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item);
    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item);
    public NFSVolumeSource getNfs();
    public A withNfs(NFSVolumeSource nfs);
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item);
    public PersistentVolumeSpecFluent.NfsNested<A> editNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item);
    public A withNewNfs(String path,Boolean readOnly,String server);
    public String getPersistentVolumeReclaimPolicy();
    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy);
    public RBDVolumeSource getRbd();
    public A withRbd(RBDVolumeSource rbd);
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item);
    public PersistentVolumeSpecFluent.RbdNested<A> editRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item);
    public VsphereVirtualDiskVolumeSource getVsphereVolume();
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume);
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public A withNewVsphereVolume(String fsType,String volumePath);

    public interface AwsElasticBlockStoreNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AWSElasticBlockStoreVolumeSourceFluent<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>{

        
    public N and();    public N endAwsElasticBlockStore();
}
    public interface AzureFileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AzureFileVolumeSourceFluent<PersistentVolumeSpecFluent.AzureFileNested<N>>{

        
    public N and();    public N endAzureFile();
}
    public interface CephfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CephFSVolumeSourceFluent<PersistentVolumeSpecFluent.CephfsNested<N>>{

        
    public N and();    public N endCephfs();
}
    public interface CinderNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CinderVolumeSourceFluent<PersistentVolumeSpecFluent.CinderNested<N>>{

        
    public N and();    public N endCinder();
}
    public interface ClaimRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<PersistentVolumeSpecFluent.ClaimRefNested<N>>{

        
    public N and();    public N endClaimRef();
}
    public interface FcNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FCVolumeSourceFluent<PersistentVolumeSpecFluent.FcNested<N>>{

        
    public N and();    public N endFc();
}
    public interface FlexVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FlexVolumeSourceFluent<PersistentVolumeSpecFluent.FlexVolumeNested<N>>{

        
    public N and();    public N endFlexVolume();
}
    public interface FlockerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FlockerVolumeSourceFluent<PersistentVolumeSpecFluent.FlockerNested<N>>{

        
    public N and();    public N endFlocker();
}
    public interface GcePersistentDiskNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GCEPersistentDiskVolumeSourceFluent<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>{

        
    public N and();    public N endGcePersistentDisk();
}
    public interface GlusterfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GlusterfsVolumeSourceFluent<PersistentVolumeSpecFluent.GlusterfsNested<N>>{

        
    public N and();    public N endGlusterfs();
}
    public interface HostPathNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HostPathVolumeSourceFluent<PersistentVolumeSpecFluent.HostPathNested<N>>{

        
    public N and();    public N endHostPath();
}
    public interface IscsiNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ISCSIVolumeSourceFluent<PersistentVolumeSpecFluent.IscsiNested<N>>{

        
    public N and();    public N endIscsi();
}
    public interface NfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NFSVolumeSourceFluent<PersistentVolumeSpecFluent.NfsNested<N>>{

        
    public N and();    public N endNfs();
}
    public interface RbdNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RBDVolumeSourceFluent<PersistentVolumeSpecFluent.RbdNested<N>>{

        
    public N and();    public N endRbd();
}
    public interface VsphereVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VsphereVirtualDiskVolumeSourceFluent<PersistentVolumeSpecFluent.VsphereVolumeNested<N>>{

        
    public N and();    public N endVsphereVolume();
}


}
