package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface PodSecurityContextFluent<A extends PodSecurityContextFluent<A>> extends Fluent<A>{


    public Long getFsGroup();
    public A withFsGroup(Long fsGroup);
    public Boolean isRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public SELinuxOptions getSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item);
    public A withNewSeLinuxOptions(String level,String role,String type,String user);
    public A addToSupplementalGroups(Long... items);
    public A removeFromSupplementalGroups(Long... items);
    public List<Long> getSupplementalGroups();
    public A withSupplementalGroups(List<Long> supplementalGroups);
    public A withSupplementalGroups(Long... supplementalGroups);

    public interface SeLinuxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxOptionsFluent<PodSecurityContextFluent.SeLinuxOptionsNested<N>>{

        
    public N and();    public N endSeLinuxOptions();
}


}
