package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PodTemplateFluent<A extends PodTemplateFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PodTemplateFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodTemplateFluent.MetadataNested<A> editMetadata();
    public PodTemplateFluent.MetadataNested<A> editOrNewMetadata();
    public PodTemplateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public PodTemplateFluent.TemplateNested<A> withNewTemplate();
    public PodTemplateFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public PodTemplateFluent.TemplateNested<A> editTemplate();
    public PodTemplateFluent.TemplateNested<A> editOrNewTemplate();
    public PodTemplateFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PodTemplateFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<PodTemplateFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
