package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PodTemplateListFluent<A extends PodTemplateListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PodTemplate... items);
    public A removeFromItems(PodTemplate... items);
    public List<PodTemplate> getItems();
    public A withItems(List<PodTemplate> items);
    public A withItems(PodTemplate... items);
    public PodTemplateListFluent.ItemsNested<A> addNewItem();
    public PodTemplateListFluent.ItemsNested<A> addNewItemLike(PodTemplate item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PodTemplateListFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PodTemplateListFluent.MetadataNested<A> editMetadata();
    public PodTemplateListFluent.MetadataNested<A> editOrNewMetadata();
    public PodTemplateListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateFluent<PodTemplateListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<PodTemplateListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
