package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ReplicationControllerStatusBuilder extends ReplicationControllerStatusFluentImpl<ReplicationControllerStatusBuilder> implements VisitableBuilder<ReplicationControllerStatus,ReplicationControllerStatusBuilder>{

    ReplicationControllerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicationControllerStatusBuilder(){
            this(true);
    }
    public ReplicationControllerStatusBuilder(Boolean validationEnabled){
            this(new ReplicationControllerStatus(), validationEnabled);
    }
    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReplicationControllerStatus(), validationEnabled);
    }
    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance){
            this(fluent, instance, true);
    }
    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance){
            this(instance,true);
    }
    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReplicationControllerStatus build(){
            ReplicationControllerStatus buildable = new ReplicationControllerStatus(fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReplicas());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplicationControllerStatusBuilder that = (ReplicationControllerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
