package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ResourceQuotaListFluent<A extends ResourceQuotaListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ResourceQuota... items);
    public A removeFromItems(ResourceQuota... items);
    public List<ResourceQuota> getItems();
    public A withItems(List<ResourceQuota> items);
    public A withItems(ResourceQuota... items);
    public ResourceQuotaListFluent.ItemsNested<A> addNewItem();
    public ResourceQuotaListFluent.ItemsNested<A> addNewItemLike(ResourceQuota item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ResourceQuotaListFluent.MetadataNested<A> withNewMetadata();
    public ResourceQuotaListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ResourceQuotaListFluent.MetadataNested<A> editMetadata();
    public ResourceQuotaListFluent.MetadataNested<A> editOrNewMetadata();
    public ResourceQuotaListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaFluent<ResourceQuotaListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ResourceQuotaListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
