package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class SELinuxContextStrategyOptionsBuilder extends SELinuxContextStrategyOptionsFluentImpl<SELinuxContextStrategyOptionsBuilder> implements VisitableBuilder<SELinuxContextStrategyOptions,SELinuxContextStrategyOptionsBuilder>{

    SELinuxContextStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public SELinuxContextStrategyOptionsBuilder(){
            this(true);
    }
    public SELinuxContextStrategyOptionsBuilder(Boolean validationEnabled){
            this(new SELinuxContextStrategyOptions(), validationEnabled);
    }
    public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SELinuxContextStrategyOptions(), validationEnabled);
    }
    public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent,SELinuxContextStrategyOptions instance){
            this(fluent, instance, true);
    }
    public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent,SELinuxContextStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptions instance){
            this(instance,true);
    }
    public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public SELinuxContextStrategyOptions build(){
            SELinuxContextStrategyOptions buildable = new SELinuxContextStrategyOptions(fluent.getSeLinuxOptions(),fluent.getType());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SELinuxContextStrategyOptionsBuilder that = (SELinuxContextStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
