package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class SELinuxOptionsBuilder extends SELinuxOptionsFluentImpl<SELinuxOptionsBuilder> implements VisitableBuilder<SELinuxOptions,SELinuxOptionsBuilder>{

    SELinuxOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public SELinuxOptionsBuilder(){
            this(true);
    }
    public SELinuxOptionsBuilder(Boolean validationEnabled){
            this(new SELinuxOptions(), validationEnabled);
    }
    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SELinuxOptions(), validationEnabled);
    }
    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,SELinuxOptions instance){
            this(fluent, instance, true);
    }
    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,SELinuxOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLevel(instance.getLevel()); 
            fluent.withRole(instance.getRole()); 
            fluent.withType(instance.getType()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public SELinuxOptionsBuilder(SELinuxOptions instance){
            this(instance,true);
    }
    public SELinuxOptionsBuilder(SELinuxOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLevel(instance.getLevel()); 
            this.withRole(instance.getRole()); 
            this.withType(instance.getType()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public SELinuxOptions build(){
            SELinuxOptions buildable = new SELinuxOptions(fluent.getLevel(),fluent.getRole(),fluent.getType(),fluent.getUser());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SELinuxOptionsBuilder that = (SELinuxOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
