package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class DaemonSetFluentImpl<A extends DaemonSetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DaemonSetFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends DaemonSetSpec,?> spec;
    private VisitableBuilder<? extends DaemonSetStatus,?> status;

    public DaemonSetFluentImpl(){
    }
    public DaemonSetFluentImpl(DaemonSet instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public DaemonSetFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public DaemonSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public DaemonSetFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public DaemonSetFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public DaemonSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public DaemonSetSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(DaemonSetSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new DaemonSetSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public DaemonSetFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public DaemonSetFluent.SpecNested<A> withNewSpecLike(DaemonSetSpec item){
            return new SpecNestedImpl(item);
    }

    public DaemonSetFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public DaemonSetFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new DaemonSetSpecBuilder().build());
    }

    public DaemonSetFluent.SpecNested<A> editOrNewSpecLike(DaemonSetSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public DaemonSetStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(DaemonSetStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new DaemonSetStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public DaemonSetFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public DaemonSetFluent.StatusNested<A> withNewStatusLike(DaemonSetStatus item){
            return new StatusNestedImpl(item);
    }

    public DaemonSetFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public DaemonSetFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new DaemonSetStatusBuilder().build());
    }

    public DaemonSetFluent.StatusNested<A> editOrNewStatusLike(DaemonSetStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public A withNewStatus(Integer currentNumberScheduled,Integer desiredNumberScheduled,Integer numberMisscheduled){
            return (A)withStatus(new DaemonSetStatus(currentNumberScheduled, desiredNumberScheduled, numberMisscheduled));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetFluentImpl that = (DaemonSetFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<DaemonSetFluent.MetadataNested<N>> implements DaemonSetFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) DaemonSetFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends DaemonSetSpecFluentImpl<DaemonSetFluent.SpecNested<N>> implements DaemonSetFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DaemonSetSpecBuilder builder;
    
            SpecNestedImpl(DaemonSetSpec item){
                    this.builder = new DaemonSetSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new DaemonSetSpecBuilder(this);
            }
    
    public N and(){
            return (N) DaemonSetFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends DaemonSetStatusFluentImpl<DaemonSetFluent.StatusNested<N>> implements DaemonSetFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DaemonSetStatusBuilder builder;
    
            StatusNestedImpl(DaemonSetStatus item){
                    this.builder = new DaemonSetStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new DaemonSetStatusBuilder(this);
            }
    
    public N and(){
            return (N) DaemonSetFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
