package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class DeploymentSpecFluentImpl<A extends DeploymentSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentSpecFluent<A>{

    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private VisitableBuilder<? extends RollbackConfig,?> rollbackTo;
    private VisitableBuilder<? extends io.fabric8.kubernetes.api.model.extensions.LabelSelector,?> selector;
    private VisitableBuilder<? extends DeploymentStrategy,?> strategy;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;

    public DeploymentSpecFluentImpl(){
    }
    public DeploymentSpecFluentImpl(DeploymentSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds()); 
            this.withPaused(instance.getPaused()); 
            this.withReplicas(instance.getReplicas()); 
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
            this.withRollbackTo(instance.getRollbackTo()); 
            this.withSelector(instance.getSelector()); 
            this.withStrategy(instance.getStrategy()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean isPaused(){
            return this.paused;
    }

    public A withPaused(Boolean paused){
            this.paused=paused; return (A) this;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public RollbackConfig getRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public A withRollbackTo(RollbackConfig rollbackTo){
            _visitables.remove(this.rollbackTo);
            if (rollbackTo!=null){ this.rollbackTo= new RollbackConfigBuilder(rollbackTo); _visitables.add(this.rollbackTo);} return (A) this;
    }

    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo(){
            return new RollbackToNestedImpl();
    }

    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item){
            return new RollbackToNestedImpl(item);
    }

    public DeploymentSpecFluent.RollbackToNested<A> editRollbackTo(){
            return withNewRollbackToLike(getRollbackTo());
    }

    public DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo(){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): new RollbackConfigBuilder().build());
    }

    public DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): item);
    }

    public A withNewRollbackTo(Long revision){
            return (A)withRollbackTo(new RollbackConfig(revision));
    }

    public io.fabric8.kubernetes.api.model.extensions.LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.extensions.LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public DeploymentSpecFluent.ExtensionsSelectorNested<A> withNewExtensionsSelector(){
            return new ExtensionsSelectorNestedImpl();
    }

    public DeploymentSpecFluent.ExtensionsSelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
            return new ExtensionsSelectorNestedImpl(item);
    }

    public DeploymentSpecFluent.ExtensionsSelectorNested<A> editExtensionsSelector(){
            return withNewSelectorLike(getSelector());
    }

    public DeploymentSpecFluent.ExtensionsSelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder().build());
    }

    public DeploymentSpecFluent.ExtensionsSelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public DeploymentStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(DeploymentStrategy strategy){
            _visitables.remove(this.strategy);
            if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }

    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item){
            return new StrategyNestedImpl(item);
    }

    public DeploymentSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new DeploymentStrategyBuilder().build());
    }

    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public DeploymentSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentSpecFluentImpl that = (DeploymentSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class RollbackToNestedImpl<N> extends RollbackConfigFluentImpl<DeploymentSpecFluent.RollbackToNested<N>> implements DeploymentSpecFluent.RollbackToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RollbackConfigBuilder builder;
    
            RollbackToNestedImpl(RollbackConfig item){
                    this.builder = new RollbackConfigBuilder(this, item);
            }
            RollbackToNestedImpl(){
                    this.builder = new RollbackConfigBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withRollbackTo(builder.build());
    }
    public N endRollbackTo(){
            return and();
    }

}
    public class ExtensionsSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl<DeploymentSpecFluent.ExtensionsSelectorNested<N>> implements DeploymentSpecFluent.ExtensionsSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder builder;
    
            ExtensionsSelectorNestedImpl(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(this, item);
            }
            ExtensionsSelectorNestedImpl(){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endExtensionsSelector(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends DeploymentStrategyFluentImpl<DeploymentSpecFluent.StrategyNested<N>> implements DeploymentSpecFluent.StrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentStrategyBuilder builder;
    
            StrategyNestedImpl(DeploymentStrategy item){
                    this.builder = new DeploymentStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new DeploymentStrategyBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DeploymentSpecFluent.TemplateNested<N>> implements DeploymentSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
