package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class HorizontalPodAutoscalerFluentImpl<A extends HorizontalPodAutoscalerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HorizontalPodAutoscalerFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends HorizontalPodAutoscalerSpec,?> spec;
    private VisitableBuilder<? extends HorizontalPodAutoscalerStatus,?> status;

    public HorizontalPodAutoscalerFluentImpl(){
    }
    public HorizontalPodAutoscalerFluentImpl(HorizontalPodAutoscaler instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public HorizontalPodAutoscalerFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public HorizontalPodAutoscalerFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public HorizontalPodAutoscalerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public HorizontalPodAutoscalerSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(HorizontalPodAutoscalerSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new HorizontalPodAutoscalerSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpecLike(HorizontalPodAutoscalerSpec item){
            return new SpecNestedImpl(item);
    }

    public HorizontalPodAutoscalerFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public HorizontalPodAutoscalerFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new HorizontalPodAutoscalerSpecBuilder().build());
    }

    public HorizontalPodAutoscalerFluent.SpecNested<A> editOrNewSpecLike(HorizontalPodAutoscalerSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public HorizontalPodAutoscalerStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(HorizontalPodAutoscalerStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new HorizontalPodAutoscalerStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatusLike(HorizontalPodAutoscalerStatus item){
            return new StatusNestedImpl(item);
    }

    public HorizontalPodAutoscalerFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public HorizontalPodAutoscalerFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new HorizontalPodAutoscalerStatusBuilder().build());
    }

    public HorizontalPodAutoscalerFluent.StatusNested<A> editOrNewStatusLike(HorizontalPodAutoscalerStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public A withNewStatus(Integer currentCPUUtilizationPercentage,Integer currentReplicas,Integer desiredReplicas,String lastScaleTime,Long observedGeneration){
            return (A)withStatus(new HorizontalPodAutoscalerStatus(currentCPUUtilizationPercentage, currentReplicas, desiredReplicas, lastScaleTime, observedGeneration));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerFluentImpl that = (HorizontalPodAutoscalerFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<HorizontalPodAutoscalerFluent.MetadataNested<N>> implements HorizontalPodAutoscalerFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerFluent.SpecNested<N>> implements HorizontalPodAutoscalerFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HorizontalPodAutoscalerSpecBuilder builder;
    
            SpecNestedImpl(HorizontalPodAutoscalerSpec item){
                    this.builder = new HorizontalPodAutoscalerSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerSpecBuilder(this);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerFluent.StatusNested<N>> implements HorizontalPodAutoscalerFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HorizontalPodAutoscalerStatusBuilder builder;
    
            StatusNestedImpl(HorizontalPodAutoscalerStatus item){
                    this.builder = new HorizontalPodAutoscalerStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerStatusBuilder(this);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
