package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface IngressFluent<A extends IngressFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public IngressFluent.MetadataNested<A> withNewMetadata();
    public IngressFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IngressFluent.MetadataNested<A> editMetadata();
    public IngressFluent.MetadataNested<A> editOrNewMetadata();
    public IngressFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public IngressSpec getSpec();
    public A withSpec(IngressSpec spec);
    public IngressFluent.SpecNested<A> withNewSpec();
    public IngressFluent.SpecNested<A> withNewSpecLike(IngressSpec item);
    public IngressFluent.SpecNested<A> editSpec();
    public IngressFluent.SpecNested<A> editOrNewSpec();
    public IngressFluent.SpecNested<A> editOrNewSpecLike(IngressSpec item);
    public IngressStatus getStatus();
    public A withStatus(IngressStatus status);
    public IngressFluent.StatusNested<A> withNewStatus();
    public IngressFluent.StatusNested<A> withNewStatusLike(IngressStatus item);
    public IngressFluent.StatusNested<A> editStatus();
    public IngressFluent.StatusNested<A> editOrNewStatus();
    public IngressFluent.StatusNested<A> editOrNewStatusLike(IngressStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<IngressFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressSpecFluent<IngressFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressStatusFluent<IngressFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
