package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class PetSetStatusBuilder extends PetSetStatusFluentImpl<PetSetStatusBuilder> implements VisitableBuilder<PetSetStatus,PetSetStatusBuilder>{

    PetSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetStatusBuilder(){
            this(true);
    }
    public PetSetStatusBuilder(Boolean validationEnabled){
            this(new PetSetStatus(), validationEnabled);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PetSetStatus(), validationEnabled);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent,PetSetStatus instance){
            this(fluent, instance, true);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent,PetSetStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }
    public PetSetStatusBuilder(PetSetStatus instance){
            this(instance,true);
    }
    public PetSetStatusBuilder(PetSetStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }

    public PetSetStatus build(){
            PetSetStatus buildable = new PetSetStatus(fluent.getObservedGeneration(),fluent.getReplicas());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetStatusBuilder that = (PetSetStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
