package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class RollbackConfigBuilder extends RollbackConfigFluentImpl<RollbackConfigBuilder> implements VisitableBuilder<RollbackConfig,RollbackConfigBuilder>{

    RollbackConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RollbackConfigBuilder(){
            this(true);
    }
    public RollbackConfigBuilder(Boolean validationEnabled){
            this(new RollbackConfig(), validationEnabled);
    }
    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent){
            this(fluent, true);
    }
    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RollbackConfig(), validationEnabled);
    }
    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,RollbackConfig instance){
            this(fluent, instance, true);
    }
    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,RollbackConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRevision(instance.getRevision()); 
            this.validationEnabled = validationEnabled; 
    }
    public RollbackConfigBuilder(RollbackConfig instance){
            this(instance,true);
    }
    public RollbackConfigBuilder(RollbackConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRevision(instance.getRevision()); 
            this.validationEnabled = validationEnabled; 
    }

    public RollbackConfig build(){
            RollbackConfig buildable = new RollbackConfig(fluent.getRevision());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RollbackConfigBuilder that = (RollbackConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
