package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ClusterPolicyFluent<A extends ClusterPolicyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getLastModified();
    public A withLastModified(String lastModified);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterPolicyFluent.MetadataNested<A> editMetadata();
    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToRoles(NamedClusterRole... items);
    public A removeFromRoles(NamedClusterRole... items);
    public List<NamedClusterRole> getRoles();
    public A withRoles(List<NamedClusterRole> roles);
    public A withRoles(NamedClusterRole... roles);
    public ClusterPolicyFluent.RolesNested<A> addNewRole();
    public ClusterPolicyFluent.RolesNested<A> addNewRoleLike(NamedClusterRole item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterPolicyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RolesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedClusterRoleFluent<ClusterPolicyFluent.RolesNested<N>>{

        
    public N and();    public N endRole();
}


}
