package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface DockerBuildStrategyFluent<A extends DockerBuildStrategyFluent<A>> extends Fluent<A>{


    public String getDockerfilePath();
    public A withDockerfilePath(String dockerfilePath);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public DockerBuildStrategyFluent.EnvNested<A> addNewEnv();
    public DockerBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public DockerBuildStrategyFluent.FromNested<A> withNewFrom();
    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public DockerBuildStrategyFluent.FromNested<A> editFrom();
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom();
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
    public Boolean isNoCache();
    public A withNoCache(Boolean noCache);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public A withNewPullSecret(String name);

    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<DockerBuildStrategyFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<DockerBuildStrategyFluent.FromNested<N>>{

        
    public N and();    public N endFrom();
}
    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<DockerBuildStrategyFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}


}
