package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface GitSourceRevisionFluent<A extends GitSourceRevisionFluent<A>> extends Fluent<A>{


    public SourceControlUser getAuthor();
    public A withAuthor(SourceControlUser author);
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthor();
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthorLike(SourceControlUser item);
    public GitSourceRevisionFluent.AuthorNested<A> editAuthor();
    public GitSourceRevisionFluent.AuthorNested<A> editOrNewAuthor();
    public GitSourceRevisionFluent.AuthorNested<A> editOrNewAuthorLike(SourceControlUser item);
    public A withNewAuthor(String email,String name);
    public String getCommit();
    public A withCommit(String commit);
    public SourceControlUser getCommitter();
    public A withCommitter(SourceControlUser committer);
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitter();
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitterLike(SourceControlUser item);
    public GitSourceRevisionFluent.CommitterNested<A> editCommitter();
    public GitSourceRevisionFluent.CommitterNested<A> editOrNewCommitter();
    public GitSourceRevisionFluent.CommitterNested<A> editOrNewCommitterLike(SourceControlUser item);
    public A withNewCommitter(String email,String name);
    public String getMessage();
    public A withMessage(String message);

    public interface AuthorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceControlUserFluent<GitSourceRevisionFluent.AuthorNested<N>>{

        
    public N and();    public N endAuthor();
}
    public interface CommitterNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceControlUserFluent<GitSourceRevisionFluent.CommitterNested<N>>{

        
    public N and();    public N endCommitter();
}


}
