package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class GroupBuilder extends GroupFluentImpl<GroupBuilder> implements VisitableBuilder<Group,GroupBuilder>{

    GroupFluent<?> fluent;
    Boolean validationEnabled;

    public GroupBuilder(){
            this(true);
    }
    public GroupBuilder(Boolean validationEnabled){
            this(new Group(), validationEnabled);
    }
    public GroupBuilder(GroupFluent<?> fluent){
            this(fluent, true);
    }
    public GroupBuilder(GroupFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Group(), validationEnabled);
    }
    public GroupBuilder(GroupFluent<?> fluent,Group instance){
            this(fluent, instance, true);
    }
    public GroupBuilder(GroupFluent<?> fluent,Group instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withUsers(instance.getUsers()); 
            this.validationEnabled = validationEnabled; 
    }
    public GroupBuilder(Group instance){
            this(instance,true);
    }
    public GroupBuilder(Group instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withUsers(instance.getUsers()); 
            this.validationEnabled = validationEnabled; 
    }

    public Group build(){
            Group buildable = new Group(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getUsers());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GroupBuilder that = (GroupBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
