package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Node;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.PodTemplateFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSetBuilder;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateBuilder;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import java.util.List;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluentImpl;
import io.fabric8.kubernetes.api.model.LimitRangeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSet;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluentImpl;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.extensions.JobFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluentImpl;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.EndpointsFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import lombok.EqualsAndHashCode;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.kubernetes.api.model.BindingFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.Namespace;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl;
import io.fabric8.kubernetes.api.model.LimitRangeFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSetFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import lombok.ToString;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EventFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluentImpl;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.BindingBuilder;
import io.fabric8.kubernetes.api.model.ComponentStatusBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.NamespaceFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Service;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.kubernetes.api.model.NodeFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;

public class ImageFluentImpl<A extends ImageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageFluent<A>{

    private String apiVersion;
    private String dockerImageConfig;
    private List<VisitableBuilder<? extends ImageLayer,?>> dockerImageLayers =  new ArrayList<VisitableBuilder<? extends ImageLayer,?>>();
    private String dockerImageManifest;
    private String dockerImageManifestMediaType;
    private VisitableBuilder<? extends HasMetadata,?> dockerImageMetadata;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private List<String> dockerImageSignatures = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private List<VisitableBuilder<? extends ImageSignature,?>> signatures =  new ArrayList<VisitableBuilder<? extends ImageSignature,?>>();

    public ImageFluentImpl(){
    }
    public ImageFluentImpl(Image instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withDockerImageConfig(instance.getDockerImageConfig()); 
            this.withDockerImageLayers(instance.getDockerImageLayers()); 
            this.withDockerImageManifest(instance.getDockerImageManifest()); 
            this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType()); 
            this.withDockerImageMetadata(instance.getDockerImageMetadata()); 
            this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); 
            this.withDockerImageReference(instance.getDockerImageReference()); 
            this.withDockerImageSignatures(instance.getDockerImageSignatures()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSignatures(instance.getSignatures()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getDockerImageConfig(){
            return this.dockerImageConfig;
    }

    public A withDockerImageConfig(String dockerImageConfig){
            this.dockerImageConfig=dockerImageConfig; return (A) this;
    }

    public A addToDockerImageLayers(ImageLayer... items){
            for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.add(builder);this.dockerImageLayers.add(builder);} return (A)this;
    }

    public A removeFromDockerImageLayers(ImageLayer... items){
            for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.remove(builder);this.dockerImageLayers.remove(builder);} return (A)this;
    }

    public List<ImageLayer> getDockerImageLayers(){
            return build(dockerImageLayers);
    }

    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers){
            _visitables.removeAll(this.dockerImageLayers);
            this.dockerImageLayers.clear();
            if (dockerImageLayers != null) {for (ImageLayer item : dockerImageLayers){this.addToDockerImageLayers(item);}} return (A) this;
    }

    public A withDockerImageLayers(ImageLayer... dockerImageLayers){
            this.dockerImageLayers.clear(); if (dockerImageLayers != null) {for (ImageLayer item :dockerImageLayers){ this.addToDockerImageLayers(item);}} return (A) this;
    }

    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer(){
            return new DockerImageLayersNestedImpl();
    }

    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item){
            return new DockerImageLayersNestedImpl(item);
    }

    public A addNewDockerImageLayer(String mediaType,String name,Long size){
            return (A)addToDockerImageLayers(new ImageLayer(mediaType, name, size));
    }

    public String getDockerImageManifest(){
            return this.dockerImageManifest;
    }

    public A withDockerImageManifest(String dockerImageManifest){
            this.dockerImageManifest=dockerImageManifest; return (A) this;
    }

    public String getDockerImageManifestMediaType(){
            return this.dockerImageManifestMediaType;
    }

    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType){
            this.dockerImageManifestMediaType=dockerImageManifestMediaType; return (A) this;
    }

    public HasMetadata getDockerImageMetadata(){
            return this.dockerImageMetadata!=null?this.dockerImageMetadata.build():null;
    }

    public A withDockerImageMetadata(HasMetadata dockerImageMetadata){
            if (dockerImageMetadata instanceof LimitRange){ this.dockerImageMetadata= new LimitRangeBuilder((LimitRange)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ThirdPartyResource){ this.dockerImageMetadata= new ThirdPartyResourceBuilder((ThirdPartyResource)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Job){ this.dockerImageMetadata= new JobBuilder((Job)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Project){ this.dockerImageMetadata= new ProjectBuilder((Project)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof SecurityContextConstraints){ this.dockerImageMetadata= new SecurityContextConstraintsBuilder((SecurityContextConstraints)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof BuildConfig){ this.dockerImageMetadata= new BuildConfigBuilder((BuildConfig)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Route){ this.dockerImageMetadata= new RouteBuilder((Route)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof OAuthAuthorizeToken){ this.dockerImageMetadata= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Namespace){ this.dockerImageMetadata= new NamespaceBuilder((Namespace)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ClusterRoleBinding){ this.dockerImageMetadata= new ClusterRoleBindingBuilder((ClusterRoleBinding)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Service){ this.dockerImageMetadata= new ServiceBuilder((Service)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ReplicationController){ this.dockerImageMetadata= new ReplicationControllerBuilder((ReplicationController)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ProjectRequest){ this.dockerImageMetadata= new ProjectRequestBuilder((ProjectRequest)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Template){ this.dockerImageMetadata= new TemplateBuilder((Template)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof OAuthClientAuthorization){ this.dockerImageMetadata= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof PolicyBinding){ this.dockerImageMetadata= new PolicyBindingBuilder((PolicyBinding)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ClusterRole){ this.dockerImageMetadata= new ClusterRoleBuilder((ClusterRole)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Scale){ this.dockerImageMetadata= new ScaleBuilder((Scale)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof PodTemplate){ this.dockerImageMetadata= new PodTemplateBuilder((PodTemplate)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Event){ this.dockerImageMetadata= new EventBuilder((Event)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Ingress){ this.dockerImageMetadata= new IngressBuilder((Ingress)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof DeploymentConfig){ this.dockerImageMetadata= new DeploymentConfigBuilder((DeploymentConfig)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof OAuthAccessToken){ this.dockerImageMetadata= new OAuthAccessTokenBuilder((OAuthAccessToken)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof RoleBinding){ this.dockerImageMetadata= new RoleBindingBuilder((RoleBinding)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof PersistentVolume){ this.dockerImageMetadata= new PersistentVolumeBuilder((PersistentVolume)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Image){ this.dockerImageMetadata= new ImageBuilder((Image)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof PersistentVolumeClaim){ this.dockerImageMetadata= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ReplicaSet){ this.dockerImageMetadata= new ReplicaSetBuilder((ReplicaSet)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Role){ this.dockerImageMetadata= new RoleBuilder((Role)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Endpoints){ this.dockerImageMetadata= new EndpointsBuilder((Endpoints)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Pod){ this.dockerImageMetadata= new PodBuilder((Pod)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ConfigMap){ this.dockerImageMetadata= new ConfigMapBuilder((ConfigMap)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ClusterPolicy){ this.dockerImageMetadata= new ClusterPolicyBuilder((ClusterPolicy)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof DaemonSet){ this.dockerImageMetadata= new DaemonSetBuilder((DaemonSet)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Deployment){ this.dockerImageMetadata= new DeploymentBuilder((Deployment)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof User){ this.dockerImageMetadata= new UserBuilder((User)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ComponentStatus){ this.dockerImageMetadata= new ComponentStatusBuilder((ComponentStatus)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Build){ this.dockerImageMetadata= new BuildBuilder((Build)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ImageStreamTag){ this.dockerImageMetadata= new ImageStreamTagBuilder((ImageStreamTag)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Group){ this.dockerImageMetadata= new GroupBuilder((Group)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof PetSet){ this.dockerImageMetadata= new PetSetBuilder((PetSet)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Policy){ this.dockerImageMetadata= new PolicyBuilder((Policy)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ImageSignature){ this.dockerImageMetadata= new ImageSignatureBuilder((ImageSignature)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Binding){ this.dockerImageMetadata= new BindingBuilder((Binding)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ResourceQuota){ this.dockerImageMetadata= new ResourceQuotaBuilder((ResourceQuota)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Secret){ this.dockerImageMetadata= new SecretBuilder((Secret)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof BuildRequest){ this.dockerImageMetadata= new BuildRequestBuilder((BuildRequest)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ClusterPolicyBinding){ this.dockerImageMetadata= new ClusterPolicyBindingBuilder((ClusterPolicyBinding)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Node){ this.dockerImageMetadata= new NodeBuilder((Node)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ImageStream){ this.dockerImageMetadata= new ImageStreamBuilder((ImageStream)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof HorizontalPodAutoscaler){ this.dockerImageMetadata= new HorizontalPodAutoscalerBuilder((HorizontalPodAutoscaler)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof OAuthClient){ this.dockerImageMetadata= new OAuthClientBuilder((OAuthClient)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof ServiceAccount){ this.dockerImageMetadata= new ServiceAccountBuilder((ServiceAccount)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            if (dockerImageMetadata instanceof Identity){ this.dockerImageMetadata= new IdentityBuilder((Identity)dockerImageMetadata); _visitables.add(this.dockerImageMetadata);}
            return (A) this;
    }

    public A withLimitRangeDockerImageMetadata(LimitRange limitRangeDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (limitRangeDockerImageMetadata!=null){ this.dockerImageMetadata= new LimitRangeBuilder(limitRangeDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.LimitRangeDockerImageMetadataNested<A> withNewLimitRangeDockerImageMetadata(){
            return new LimitRangeDockerImageMetadataNestedImpl();
    }

    public ImageFluent.LimitRangeDockerImageMetadataNested<A> withNewLimitRangeDockerImageMetadataLike(LimitRange item){
            return new LimitRangeDockerImageMetadataNestedImpl(item);
    }

    public A withThirdPartyResourceDockerImageMetadata(ThirdPartyResource thirdPartyResourceDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (thirdPartyResourceDockerImageMetadata!=null){ this.dockerImageMetadata= new ThirdPartyResourceBuilder(thirdPartyResourceDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ThirdPartyResourceDockerImageMetadataNested<A> withNewThirdPartyResourceDockerImageMetadata(){
            return new ThirdPartyResourceDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ThirdPartyResourceDockerImageMetadataNested<A> withNewThirdPartyResourceDockerImageMetadataLike(ThirdPartyResource item){
            return new ThirdPartyResourceDockerImageMetadataNestedImpl(item);
    }

    public A withJobDockerImageMetadata(Job jobDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (jobDockerImageMetadata!=null){ this.dockerImageMetadata= new JobBuilder(jobDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.JobDockerImageMetadataNested<A> withNewJobDockerImageMetadata(){
            return new JobDockerImageMetadataNestedImpl();
    }

    public ImageFluent.JobDockerImageMetadataNested<A> withNewJobDockerImageMetadataLike(Job item){
            return new JobDockerImageMetadataNestedImpl(item);
    }

    public A withProjectDockerImageMetadata(Project projectDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (projectDockerImageMetadata!=null){ this.dockerImageMetadata= new ProjectBuilder(projectDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ProjectDockerImageMetadataNested<A> withNewProjectDockerImageMetadata(){
            return new ProjectDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ProjectDockerImageMetadataNested<A> withNewProjectDockerImageMetadataLike(Project item){
            return new ProjectDockerImageMetadataNestedImpl(item);
    }

    public A withSecurityContextConstraintsDockerImageMetadata(SecurityContextConstraints securityContextConstraintsDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (securityContextConstraintsDockerImageMetadata!=null){ this.dockerImageMetadata= new SecurityContextConstraintsBuilder(securityContextConstraintsDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<A> withNewSecurityContextConstraintsDockerImageMetadata(){
            return new SecurityContextConstraintsDockerImageMetadataNestedImpl();
    }

    public ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<A> withNewSecurityContextConstraintsDockerImageMetadataLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsDockerImageMetadataNestedImpl(item);
    }

    public A withBuildConfigDockerImageMetadata(BuildConfig buildConfigDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (buildConfigDockerImageMetadata!=null){ this.dockerImageMetadata= new BuildConfigBuilder(buildConfigDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.BuildConfigDockerImageMetadataNested<A> withNewBuildConfigDockerImageMetadata(){
            return new BuildConfigDockerImageMetadataNestedImpl();
    }

    public ImageFluent.BuildConfigDockerImageMetadataNested<A> withNewBuildConfigDockerImageMetadataLike(BuildConfig item){
            return new BuildConfigDockerImageMetadataNestedImpl(item);
    }

    public A withRouteDockerImageMetadata(Route routeDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (routeDockerImageMetadata!=null){ this.dockerImageMetadata= new RouteBuilder(routeDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.RouteDockerImageMetadataNested<A> withNewRouteDockerImageMetadata(){
            return new RouteDockerImageMetadataNestedImpl();
    }

    public ImageFluent.RouteDockerImageMetadataNested<A> withNewRouteDockerImageMetadataLike(Route item){
            return new RouteDockerImageMetadataNestedImpl(item);
    }

    public A withOAuthAuthorizeTokenDockerImageMetadata(OAuthAuthorizeToken oAuthAuthorizeTokenDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (oAuthAuthorizeTokenDockerImageMetadata!=null){ this.dockerImageMetadata= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<A> withNewOAuthAuthorizeTokenDockerImageMetadata(){
            return new OAuthAuthorizeTokenDockerImageMetadataNestedImpl();
    }

    public ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<A> withNewOAuthAuthorizeTokenDockerImageMetadataLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenDockerImageMetadataNestedImpl(item);
    }

    public A withNamespaceDockerImageMetadata(Namespace namespaceDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (namespaceDockerImageMetadata!=null){ this.dockerImageMetadata= new NamespaceBuilder(namespaceDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.NamespaceDockerImageMetadataNested<A> withNewNamespaceDockerImageMetadata(){
            return new NamespaceDockerImageMetadataNestedImpl();
    }

    public ImageFluent.NamespaceDockerImageMetadataNested<A> withNewNamespaceDockerImageMetadataLike(Namespace item){
            return new NamespaceDockerImageMetadataNestedImpl(item);
    }

    public A withClusterRoleBindingDockerImageMetadata(ClusterRoleBinding clusterRoleBindingDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (clusterRoleBindingDockerImageMetadata!=null){ this.dockerImageMetadata= new ClusterRoleBindingBuilder(clusterRoleBindingDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ClusterRoleBindingDockerImageMetadataNested<A> withNewClusterRoleBindingDockerImageMetadata(){
            return new ClusterRoleBindingDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ClusterRoleBindingDockerImageMetadataNested<A> withNewClusterRoleBindingDockerImageMetadataLike(ClusterRoleBinding item){
            return new ClusterRoleBindingDockerImageMetadataNestedImpl(item);
    }

    public A withServiceDockerImageMetadata(Service serviceDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (serviceDockerImageMetadata!=null){ this.dockerImageMetadata= new ServiceBuilder(serviceDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ServiceDockerImageMetadataNested<A> withNewServiceDockerImageMetadata(){
            return new ServiceDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ServiceDockerImageMetadataNested<A> withNewServiceDockerImageMetadataLike(Service item){
            return new ServiceDockerImageMetadataNestedImpl(item);
    }

    public A withReplicationControllerDockerImageMetadata(ReplicationController replicationControllerDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (replicationControllerDockerImageMetadata!=null){ this.dockerImageMetadata= new ReplicationControllerBuilder(replicationControllerDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ReplicationControllerDockerImageMetadataNested<A> withNewReplicationControllerDockerImageMetadata(){
            return new ReplicationControllerDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ReplicationControllerDockerImageMetadataNested<A> withNewReplicationControllerDockerImageMetadataLike(ReplicationController item){
            return new ReplicationControllerDockerImageMetadataNestedImpl(item);
    }

    public A withProjectRequestDockerImageMetadata(ProjectRequest projectRequestDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (projectRequestDockerImageMetadata!=null){ this.dockerImageMetadata= new ProjectRequestBuilder(projectRequestDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ProjectRequestDockerImageMetadataNested<A> withNewProjectRequestDockerImageMetadata(){
            return new ProjectRequestDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ProjectRequestDockerImageMetadataNested<A> withNewProjectRequestDockerImageMetadataLike(ProjectRequest item){
            return new ProjectRequestDockerImageMetadataNestedImpl(item);
    }

    public A withTemplateDockerImageMetadata(Template templateDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (templateDockerImageMetadata!=null){ this.dockerImageMetadata= new TemplateBuilder(templateDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.TemplateDockerImageMetadataNested<A> withNewTemplateDockerImageMetadata(){
            return new TemplateDockerImageMetadataNestedImpl();
    }

    public ImageFluent.TemplateDockerImageMetadataNested<A> withNewTemplateDockerImageMetadataLike(Template item){
            return new TemplateDockerImageMetadataNestedImpl(item);
    }

    public A withOAuthClientAuthorizationDockerImageMetadata(OAuthClientAuthorization oAuthClientAuthorizationDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (oAuthClientAuthorizationDockerImageMetadata!=null){ this.dockerImageMetadata= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<A> withNewOAuthClientAuthorizationDockerImageMetadata(){
            return new OAuthClientAuthorizationDockerImageMetadataNestedImpl();
    }

    public ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<A> withNewOAuthClientAuthorizationDockerImageMetadataLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationDockerImageMetadataNestedImpl(item);
    }

    public A withPolicyBindingDockerImageMetadata(PolicyBinding policyBindingDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (policyBindingDockerImageMetadata!=null){ this.dockerImageMetadata= new PolicyBindingBuilder(policyBindingDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PolicyBindingDockerImageMetadataNested<A> withNewPolicyBindingDockerImageMetadata(){
            return new PolicyBindingDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PolicyBindingDockerImageMetadataNested<A> withNewPolicyBindingDockerImageMetadataLike(PolicyBinding item){
            return new PolicyBindingDockerImageMetadataNestedImpl(item);
    }

    public A withClusterRoleDockerImageMetadata(ClusterRole clusterRoleDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (clusterRoleDockerImageMetadata!=null){ this.dockerImageMetadata= new ClusterRoleBuilder(clusterRoleDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ClusterRoleDockerImageMetadataNested<A> withNewClusterRoleDockerImageMetadata(){
            return new ClusterRoleDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ClusterRoleDockerImageMetadataNested<A> withNewClusterRoleDockerImageMetadataLike(ClusterRole item){
            return new ClusterRoleDockerImageMetadataNestedImpl(item);
    }

    public A withScaleDockerImageMetadata(Scale scaleDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (scaleDockerImageMetadata!=null){ this.dockerImageMetadata= new ScaleBuilder(scaleDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ScaleDockerImageMetadataNested<A> withNewScaleDockerImageMetadata(){
            return new ScaleDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ScaleDockerImageMetadataNested<A> withNewScaleDockerImageMetadataLike(Scale item){
            return new ScaleDockerImageMetadataNestedImpl(item);
    }

    public A withPodTemplateDockerImageMetadata(PodTemplate podTemplateDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (podTemplateDockerImageMetadata!=null){ this.dockerImageMetadata= new PodTemplateBuilder(podTemplateDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PodTemplateDockerImageMetadataNested<A> withNewPodTemplateDockerImageMetadata(){
            return new PodTemplateDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PodTemplateDockerImageMetadataNested<A> withNewPodTemplateDockerImageMetadataLike(PodTemplate item){
            return new PodTemplateDockerImageMetadataNestedImpl(item);
    }

    public A withEventDockerImageMetadata(Event eventDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (eventDockerImageMetadata!=null){ this.dockerImageMetadata= new EventBuilder(eventDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.EventDockerImageMetadataNested<A> withNewEventDockerImageMetadata(){
            return new EventDockerImageMetadataNestedImpl();
    }

    public ImageFluent.EventDockerImageMetadataNested<A> withNewEventDockerImageMetadataLike(Event item){
            return new EventDockerImageMetadataNestedImpl(item);
    }

    public A withIngressDockerImageMetadata(Ingress ingressDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (ingressDockerImageMetadata!=null){ this.dockerImageMetadata= new IngressBuilder(ingressDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.IngressDockerImageMetadataNested<A> withNewIngressDockerImageMetadata(){
            return new IngressDockerImageMetadataNestedImpl();
    }

    public ImageFluent.IngressDockerImageMetadataNested<A> withNewIngressDockerImageMetadataLike(Ingress item){
            return new IngressDockerImageMetadataNestedImpl(item);
    }

    public A withDeploymentConfigDockerImageMetadata(DeploymentConfig deploymentConfigDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (deploymentConfigDockerImageMetadata!=null){ this.dockerImageMetadata= new DeploymentConfigBuilder(deploymentConfigDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.DeploymentConfigDockerImageMetadataNested<A> withNewDeploymentConfigDockerImageMetadata(){
            return new DeploymentConfigDockerImageMetadataNestedImpl();
    }

    public ImageFluent.DeploymentConfigDockerImageMetadataNested<A> withNewDeploymentConfigDockerImageMetadataLike(DeploymentConfig item){
            return new DeploymentConfigDockerImageMetadataNestedImpl(item);
    }

    public A withOAuthAccessTokenDockerImageMetadata(OAuthAccessToken oAuthAccessTokenDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (oAuthAccessTokenDockerImageMetadata!=null){ this.dockerImageMetadata= new OAuthAccessTokenBuilder(oAuthAccessTokenDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.OAuthAccessTokenDockerImageMetadataNested<A> withNewOAuthAccessTokenDockerImageMetadata(){
            return new OAuthAccessTokenDockerImageMetadataNestedImpl();
    }

    public ImageFluent.OAuthAccessTokenDockerImageMetadataNested<A> withNewOAuthAccessTokenDockerImageMetadataLike(OAuthAccessToken item){
            return new OAuthAccessTokenDockerImageMetadataNestedImpl(item);
    }

    public A withRoleBindingDockerImageMetadata(RoleBinding roleBindingDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (roleBindingDockerImageMetadata!=null){ this.dockerImageMetadata= new RoleBindingBuilder(roleBindingDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.RoleBindingDockerImageMetadataNested<A> withNewRoleBindingDockerImageMetadata(){
            return new RoleBindingDockerImageMetadataNestedImpl();
    }

    public ImageFluent.RoleBindingDockerImageMetadataNested<A> withNewRoleBindingDockerImageMetadataLike(RoleBinding item){
            return new RoleBindingDockerImageMetadataNestedImpl(item);
    }

    public A withPersistentVolumeDockerImageMetadata(PersistentVolume persistentVolumeDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (persistentVolumeDockerImageMetadata!=null){ this.dockerImageMetadata= new PersistentVolumeBuilder(persistentVolumeDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PersistentVolumeDockerImageMetadataNested<A> withNewPersistentVolumeDockerImageMetadata(){
            return new PersistentVolumeDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PersistentVolumeDockerImageMetadataNested<A> withNewPersistentVolumeDockerImageMetadataLike(PersistentVolume item){
            return new PersistentVolumeDockerImageMetadataNestedImpl(item);
    }

    public A withImageDockerImageMetadata(Image imageDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (imageDockerImageMetadata!=null){ this.dockerImageMetadata= new ImageBuilder(imageDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ImageDockerImageMetadataNested<A> withNewImageDockerImageMetadata(){
            return new ImageDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ImageDockerImageMetadataNested<A> withNewImageDockerImageMetadataLike(Image item){
            return new ImageDockerImageMetadataNestedImpl(item);
    }

    public A withPersistentVolumeClaimDockerImageMetadata(PersistentVolumeClaim persistentVolumeClaimDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (persistentVolumeClaimDockerImageMetadata!=null){ this.dockerImageMetadata= new PersistentVolumeClaimBuilder(persistentVolumeClaimDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<A> withNewPersistentVolumeClaimDockerImageMetadata(){
            return new PersistentVolumeClaimDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<A> withNewPersistentVolumeClaimDockerImageMetadataLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimDockerImageMetadataNestedImpl(item);
    }

    public A withReplicaSetDockerImageMetadata(ReplicaSet replicaSetDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (replicaSetDockerImageMetadata!=null){ this.dockerImageMetadata= new ReplicaSetBuilder(replicaSetDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ReplicaSetDockerImageMetadataNested<A> withNewReplicaSetDockerImageMetadata(){
            return new ReplicaSetDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ReplicaSetDockerImageMetadataNested<A> withNewReplicaSetDockerImageMetadataLike(ReplicaSet item){
            return new ReplicaSetDockerImageMetadataNestedImpl(item);
    }

    public A withRoleDockerImageMetadata(Role roleDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (roleDockerImageMetadata!=null){ this.dockerImageMetadata= new RoleBuilder(roleDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.RoleDockerImageMetadataNested<A> withNewRoleDockerImageMetadata(){
            return new RoleDockerImageMetadataNestedImpl();
    }

    public ImageFluent.RoleDockerImageMetadataNested<A> withNewRoleDockerImageMetadataLike(Role item){
            return new RoleDockerImageMetadataNestedImpl(item);
    }

    public A withEndpointsDockerImageMetadata(Endpoints endpointsDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (endpointsDockerImageMetadata!=null){ this.dockerImageMetadata= new EndpointsBuilder(endpointsDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.EndpointsDockerImageMetadataNested<A> withNewEndpointsDockerImageMetadata(){
            return new EndpointsDockerImageMetadataNestedImpl();
    }

    public ImageFluent.EndpointsDockerImageMetadataNested<A> withNewEndpointsDockerImageMetadataLike(Endpoints item){
            return new EndpointsDockerImageMetadataNestedImpl(item);
    }

    public A withPodDockerImageMetadata(Pod podDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (podDockerImageMetadata!=null){ this.dockerImageMetadata= new PodBuilder(podDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PodDockerImageMetadataNested<A> withNewPodDockerImageMetadata(){
            return new PodDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PodDockerImageMetadataNested<A> withNewPodDockerImageMetadataLike(Pod item){
            return new PodDockerImageMetadataNestedImpl(item);
    }

    public A withConfigMapDockerImageMetadata(ConfigMap configMapDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (configMapDockerImageMetadata!=null){ this.dockerImageMetadata= new ConfigMapBuilder(configMapDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ConfigMapDockerImageMetadataNested<A> withNewConfigMapDockerImageMetadata(){
            return new ConfigMapDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ConfigMapDockerImageMetadataNested<A> withNewConfigMapDockerImageMetadataLike(ConfigMap item){
            return new ConfigMapDockerImageMetadataNestedImpl(item);
    }

    public A withClusterPolicyDockerImageMetadata(ClusterPolicy clusterPolicyDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (clusterPolicyDockerImageMetadata!=null){ this.dockerImageMetadata= new ClusterPolicyBuilder(clusterPolicyDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ClusterPolicyDockerImageMetadataNested<A> withNewClusterPolicyDockerImageMetadata(){
            return new ClusterPolicyDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ClusterPolicyDockerImageMetadataNested<A> withNewClusterPolicyDockerImageMetadataLike(ClusterPolicy item){
            return new ClusterPolicyDockerImageMetadataNestedImpl(item);
    }

    public A withDaemonSetDockerImageMetadata(DaemonSet daemonSetDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (daemonSetDockerImageMetadata!=null){ this.dockerImageMetadata= new DaemonSetBuilder(daemonSetDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.DaemonSetDockerImageMetadataNested<A> withNewDaemonSetDockerImageMetadata(){
            return new DaemonSetDockerImageMetadataNestedImpl();
    }

    public ImageFluent.DaemonSetDockerImageMetadataNested<A> withNewDaemonSetDockerImageMetadataLike(DaemonSet item){
            return new DaemonSetDockerImageMetadataNestedImpl(item);
    }

    public A withDeploymentDockerImageMetadata(Deployment deploymentDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (deploymentDockerImageMetadata!=null){ this.dockerImageMetadata= new DeploymentBuilder(deploymentDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.DeploymentDockerImageMetadataNested<A> withNewDeploymentDockerImageMetadata(){
            return new DeploymentDockerImageMetadataNestedImpl();
    }

    public ImageFluent.DeploymentDockerImageMetadataNested<A> withNewDeploymentDockerImageMetadataLike(Deployment item){
            return new DeploymentDockerImageMetadataNestedImpl(item);
    }

    public A withUserDockerImageMetadata(User userDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (userDockerImageMetadata!=null){ this.dockerImageMetadata= new UserBuilder(userDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.UserDockerImageMetadataNested<A> withNewUserDockerImageMetadata(){
            return new UserDockerImageMetadataNestedImpl();
    }

    public ImageFluent.UserDockerImageMetadataNested<A> withNewUserDockerImageMetadataLike(User item){
            return new UserDockerImageMetadataNestedImpl(item);
    }

    public A withComponentStatusDockerImageMetadata(ComponentStatus componentStatusDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (componentStatusDockerImageMetadata!=null){ this.dockerImageMetadata= new ComponentStatusBuilder(componentStatusDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ComponentStatusDockerImageMetadataNested<A> withNewComponentStatusDockerImageMetadata(){
            return new ComponentStatusDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ComponentStatusDockerImageMetadataNested<A> withNewComponentStatusDockerImageMetadataLike(ComponentStatus item){
            return new ComponentStatusDockerImageMetadataNestedImpl(item);
    }

    public A withBuildDockerImageMetadata(Build buildDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (buildDockerImageMetadata!=null){ this.dockerImageMetadata= new BuildBuilder(buildDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.BuildDockerImageMetadataNested<A> withNewBuildDockerImageMetadata(){
            return new BuildDockerImageMetadataNestedImpl();
    }

    public ImageFluent.BuildDockerImageMetadataNested<A> withNewBuildDockerImageMetadataLike(Build item){
            return new BuildDockerImageMetadataNestedImpl(item);
    }

    public A withImageStreamTagDockerImageMetadata(ImageStreamTag imageStreamTagDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (imageStreamTagDockerImageMetadata!=null){ this.dockerImageMetadata= new ImageStreamTagBuilder(imageStreamTagDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ImageStreamTagDockerImageMetadataNested<A> withNewImageStreamTagDockerImageMetadata(){
            return new ImageStreamTagDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ImageStreamTagDockerImageMetadataNested<A> withNewImageStreamTagDockerImageMetadataLike(ImageStreamTag item){
            return new ImageStreamTagDockerImageMetadataNestedImpl(item);
    }

    public A withGroupDockerImageMetadata(Group groupDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (groupDockerImageMetadata!=null){ this.dockerImageMetadata= new GroupBuilder(groupDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.GroupDockerImageMetadataNested<A> withNewGroupDockerImageMetadata(){
            return new GroupDockerImageMetadataNestedImpl();
    }

    public ImageFluent.GroupDockerImageMetadataNested<A> withNewGroupDockerImageMetadataLike(Group item){
            return new GroupDockerImageMetadataNestedImpl(item);
    }

    public A withPetSetDockerImageMetadata(PetSet petSetDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (petSetDockerImageMetadata!=null){ this.dockerImageMetadata= new PetSetBuilder(petSetDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PetSetDockerImageMetadataNested<A> withNewPetSetDockerImageMetadata(){
            return new PetSetDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PetSetDockerImageMetadataNested<A> withNewPetSetDockerImageMetadataLike(PetSet item){
            return new PetSetDockerImageMetadataNestedImpl(item);
    }

    public A withPolicyDockerImageMetadata(Policy policyDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (policyDockerImageMetadata!=null){ this.dockerImageMetadata= new PolicyBuilder(policyDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.PolicyDockerImageMetadataNested<A> withNewPolicyDockerImageMetadata(){
            return new PolicyDockerImageMetadataNestedImpl();
    }

    public ImageFluent.PolicyDockerImageMetadataNested<A> withNewPolicyDockerImageMetadataLike(Policy item){
            return new PolicyDockerImageMetadataNestedImpl(item);
    }

    public A withImageSignatureDockerImageMetadata(ImageSignature imageSignatureDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (imageSignatureDockerImageMetadata!=null){ this.dockerImageMetadata= new ImageSignatureBuilder(imageSignatureDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ImageSignatureDockerImageMetadataNested<A> withNewImageSignatureDockerImageMetadata(){
            return new ImageSignatureDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ImageSignatureDockerImageMetadataNested<A> withNewImageSignatureDockerImageMetadataLike(ImageSignature item){
            return new ImageSignatureDockerImageMetadataNestedImpl(item);
    }

    public A withBindingDockerImageMetadata(Binding bindingDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (bindingDockerImageMetadata!=null){ this.dockerImageMetadata= new BindingBuilder(bindingDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.BindingDockerImageMetadataNested<A> withNewBindingDockerImageMetadata(){
            return new BindingDockerImageMetadataNestedImpl();
    }

    public ImageFluent.BindingDockerImageMetadataNested<A> withNewBindingDockerImageMetadataLike(Binding item){
            return new BindingDockerImageMetadataNestedImpl(item);
    }

    public A withResourceQuotaDockerImageMetadata(ResourceQuota resourceQuotaDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (resourceQuotaDockerImageMetadata!=null){ this.dockerImageMetadata= new ResourceQuotaBuilder(resourceQuotaDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ResourceQuotaDockerImageMetadataNested<A> withNewResourceQuotaDockerImageMetadata(){
            return new ResourceQuotaDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ResourceQuotaDockerImageMetadataNested<A> withNewResourceQuotaDockerImageMetadataLike(ResourceQuota item){
            return new ResourceQuotaDockerImageMetadataNestedImpl(item);
    }

    public A withSecretDockerImageMetadata(Secret secretDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (secretDockerImageMetadata!=null){ this.dockerImageMetadata= new SecretBuilder(secretDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.SecretDockerImageMetadataNested<A> withNewSecretDockerImageMetadata(){
            return new SecretDockerImageMetadataNestedImpl();
    }

    public ImageFluent.SecretDockerImageMetadataNested<A> withNewSecretDockerImageMetadataLike(Secret item){
            return new SecretDockerImageMetadataNestedImpl(item);
    }

    public A withBuildRequestDockerImageMetadata(BuildRequest buildRequestDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (buildRequestDockerImageMetadata!=null){ this.dockerImageMetadata= new BuildRequestBuilder(buildRequestDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.BuildRequestDockerImageMetadataNested<A> withNewBuildRequestDockerImageMetadata(){
            return new BuildRequestDockerImageMetadataNestedImpl();
    }

    public ImageFluent.BuildRequestDockerImageMetadataNested<A> withNewBuildRequestDockerImageMetadataLike(BuildRequest item){
            return new BuildRequestDockerImageMetadataNestedImpl(item);
    }

    public A withClusterPolicyBindingDockerImageMetadata(ClusterPolicyBinding clusterPolicyBindingDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (clusterPolicyBindingDockerImageMetadata!=null){ this.dockerImageMetadata= new ClusterPolicyBindingBuilder(clusterPolicyBindingDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<A> withNewClusterPolicyBindingDockerImageMetadata(){
            return new ClusterPolicyBindingDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<A> withNewClusterPolicyBindingDockerImageMetadataLike(ClusterPolicyBinding item){
            return new ClusterPolicyBindingDockerImageMetadataNestedImpl(item);
    }

    public A withNodeDockerImageMetadata(Node nodeDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (nodeDockerImageMetadata!=null){ this.dockerImageMetadata= new NodeBuilder(nodeDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.NodeDockerImageMetadataNested<A> withNewNodeDockerImageMetadata(){
            return new NodeDockerImageMetadataNestedImpl();
    }

    public ImageFluent.NodeDockerImageMetadataNested<A> withNewNodeDockerImageMetadataLike(Node item){
            return new NodeDockerImageMetadataNestedImpl(item);
    }

    public A withImageStreamDockerImageMetadata(ImageStream imageStreamDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (imageStreamDockerImageMetadata!=null){ this.dockerImageMetadata= new ImageStreamBuilder(imageStreamDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ImageStreamDockerImageMetadataNested<A> withNewImageStreamDockerImageMetadata(){
            return new ImageStreamDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ImageStreamDockerImageMetadataNested<A> withNewImageStreamDockerImageMetadataLike(ImageStream item){
            return new ImageStreamDockerImageMetadataNestedImpl(item);
    }

    public A withHorizontalPodAutoscalerDockerImageMetadata(HorizontalPodAutoscaler horizontalPodAutoscalerDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (horizontalPodAutoscalerDockerImageMetadata!=null){ this.dockerImageMetadata= new HorizontalPodAutoscalerBuilder(horizontalPodAutoscalerDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<A> withNewHorizontalPodAutoscalerDockerImageMetadata(){
            return new HorizontalPodAutoscalerDockerImageMetadataNestedImpl();
    }

    public ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<A> withNewHorizontalPodAutoscalerDockerImageMetadataLike(HorizontalPodAutoscaler item){
            return new HorizontalPodAutoscalerDockerImageMetadataNestedImpl(item);
    }

    public A withOAuthClientDockerImageMetadata(OAuthClient oAuthClientDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (oAuthClientDockerImageMetadata!=null){ this.dockerImageMetadata= new OAuthClientBuilder(oAuthClientDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.OAuthClientDockerImageMetadataNested<A> withNewOAuthClientDockerImageMetadata(){
            return new OAuthClientDockerImageMetadataNestedImpl();
    }

    public ImageFluent.OAuthClientDockerImageMetadataNested<A> withNewOAuthClientDockerImageMetadataLike(OAuthClient item){
            return new OAuthClientDockerImageMetadataNestedImpl(item);
    }

    public A withServiceAccountDockerImageMetadata(ServiceAccount serviceAccountDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (serviceAccountDockerImageMetadata!=null){ this.dockerImageMetadata= new ServiceAccountBuilder(serviceAccountDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.ServiceAccountDockerImageMetadataNested<A> withNewServiceAccountDockerImageMetadata(){
            return new ServiceAccountDockerImageMetadataNestedImpl();
    }

    public ImageFluent.ServiceAccountDockerImageMetadataNested<A> withNewServiceAccountDockerImageMetadataLike(ServiceAccount item){
            return new ServiceAccountDockerImageMetadataNestedImpl(item);
    }

    public A withIdentityDockerImageMetadata(Identity identityDockerImageMetadata){
            _visitables.remove(this.dockerImageMetadata);
            if (identityDockerImageMetadata!=null){ this.dockerImageMetadata= new IdentityBuilder(identityDockerImageMetadata); _visitables.add(this.dockerImageMetadata);} return (A) this;
    }

    public ImageFluent.IdentityDockerImageMetadataNested<A> withNewIdentityDockerImageMetadata(){
            return new IdentityDockerImageMetadataNestedImpl();
    }

    public ImageFluent.IdentityDockerImageMetadataNested<A> withNewIdentityDockerImageMetadataLike(Identity item){
            return new IdentityDockerImageMetadataNestedImpl(item);
    }

    public String getDockerImageMetadataVersion(){
            return this.dockerImageMetadataVersion;
    }

    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion){
            this.dockerImageMetadataVersion=dockerImageMetadataVersion; return (A) this;
    }

    public String getDockerImageReference(){
            return this.dockerImageReference;
    }

    public A withDockerImageReference(String dockerImageReference){
            this.dockerImageReference=dockerImageReference; return (A) this;
    }

    public A addToDockerImageSignatures(String... items){
            for (String item : items) {this.dockerImageSignatures.add(item);} return (A)this;
    }

    public A removeFromDockerImageSignatures(String... items){
            for (String item : items) {this.dockerImageSignatures.remove(item);} return (A)this;
    }

    public List<String> getDockerImageSignatures(){
            return this.dockerImageSignatures;
    }

    public A withDockerImageSignatures(List<String> dockerImageSignatures){
            this.dockerImageSignatures.clear();
            if (dockerImageSignatures != null) {for (String item : dockerImageSignatures){this.addToDockerImageSignatures(item);}} return (A) this;
    }

    public A withDockerImageSignatures(String... dockerImageSignatures){
            this.dockerImageSignatures.clear(); if (dockerImageSignatures != null) {for (String item :dockerImageSignatures){ this.addToDockerImageSignatures(item);}} return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ImageFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ImageFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ImageFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToSignatures(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(builder);this.signatures.add(builder);} return (A)this;
    }

    public A removeFromSignatures(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.remove(builder);this.signatures.remove(builder);} return (A)this;
    }

    public List<ImageSignature> getSignatures(){
            return build(signatures);
    }

    public A withSignatures(List<ImageSignature> signatures){
            _visitables.removeAll(this.signatures);
            this.signatures.clear();
            if (signatures != null) {for (ImageSignature item : signatures){this.addToSignatures(item);}} return (A) this;
    }

    public A withSignatures(ImageSignature... signatures){
            this.signatures.clear(); if (signatures != null) {for (ImageSignature item :signatures){ this.addToSignatures(item);}} return (A) this;
    }

    public ImageFluent.SignaturesNested<A> addNewSignature(){
            return new SignaturesNestedImpl();
    }

    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item){
            return new SignaturesNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageFluentImpl that = (ImageFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (dockerImageConfig != null ? !dockerImageConfig.equals(that.dockerImageConfig) :that.dockerImageConfig != null) return false;
            if (dockerImageLayers != null ? !dockerImageLayers.equals(that.dockerImageLayers) :that.dockerImageLayers != null) return false;
            if (dockerImageManifest != null ? !dockerImageManifest.equals(that.dockerImageManifest) :that.dockerImageManifest != null) return false;
            if (dockerImageManifestMediaType != null ? !dockerImageManifestMediaType.equals(that.dockerImageManifestMediaType) :that.dockerImageManifestMediaType != null) return false;
            if (dockerImageMetadata != null ? !dockerImageMetadata.equals(that.dockerImageMetadata) :that.dockerImageMetadata != null) return false;
            if (dockerImageMetadataVersion != null ? !dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) :that.dockerImageMetadataVersion != null) return false;
            if (dockerImageReference != null ? !dockerImageReference.equals(that.dockerImageReference) :that.dockerImageReference != null) return false;
            if (dockerImageSignatures != null ? !dockerImageSignatures.equals(that.dockerImageSignatures) :that.dockerImageSignatures != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (signatures != null ? !signatures.equals(that.signatures) :that.signatures != null) return false;
            return true;
    }


    public class DockerImageLayersNestedImpl<N> extends ImageLayerFluentImpl<ImageFluent.DockerImageLayersNested<N>> implements ImageFluent.DockerImageLayersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageLayerBuilder builder;
    
            DockerImageLayersNestedImpl(ImageLayer item){
                    this.builder = new ImageLayerBuilder(this, item);
            }
            DockerImageLayersNestedImpl(){
                    this.builder = new ImageLayerBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.addToDockerImageLayers(builder.build());
    }
    public N endDockerImageLayer(){
            return and();
    }

}
    public class LimitRangeDockerImageMetadataNestedImpl<N> extends LimitRangeFluentImpl<ImageFluent.LimitRangeDockerImageMetadataNested<N>> implements ImageFluent.LimitRangeDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LimitRangeBuilder builder;
    
            LimitRangeDockerImageMetadataNestedImpl(LimitRange item){
                    this.builder = new LimitRangeBuilder(this, item);
            }
            LimitRangeDockerImageMetadataNestedImpl(){
                    this.builder = new LimitRangeBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withLimitRangeDockerImageMetadata(builder.build());
    }
    public N endLimitRangeDockerImageMetadata(){
            return and();
    }

}
    public class ThirdPartyResourceDockerImageMetadataNestedImpl<N> extends ThirdPartyResourceFluentImpl<ImageFluent.ThirdPartyResourceDockerImageMetadataNested<N>> implements ImageFluent.ThirdPartyResourceDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ThirdPartyResourceBuilder builder;
    
            ThirdPartyResourceDockerImageMetadataNestedImpl(ThirdPartyResource item){
                    this.builder = new ThirdPartyResourceBuilder(this, item);
            }
            ThirdPartyResourceDockerImageMetadataNestedImpl(){
                    this.builder = new ThirdPartyResourceBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withThirdPartyResourceDockerImageMetadata(builder.build());
    }
    public N endThirdPartyResourceDockerImageMetadata(){
            return and();
    }

}
    public class JobDockerImageMetadataNestedImpl<N> extends JobFluentImpl<ImageFluent.JobDockerImageMetadataNested<N>> implements ImageFluent.JobDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JobBuilder builder;
    
            JobDockerImageMetadataNestedImpl(Job item){
                    this.builder = new JobBuilder(this, item);
            }
            JobDockerImageMetadataNestedImpl(){
                    this.builder = new JobBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withJobDockerImageMetadata(builder.build());
    }
    public N endJobDockerImageMetadata(){
            return and();
    }

}
    public class ProjectDockerImageMetadataNestedImpl<N> extends ProjectFluentImpl<ImageFluent.ProjectDockerImageMetadataNested<N>> implements ImageFluent.ProjectDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectBuilder builder;
    
            ProjectDockerImageMetadataNestedImpl(Project item){
                    this.builder = new ProjectBuilder(this, item);
            }
            ProjectDockerImageMetadataNestedImpl(){
                    this.builder = new ProjectBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withProjectDockerImageMetadata(builder.build());
    }
    public N endProjectDockerImageMetadata(){
            return and();
    }

}
    public class SecurityContextConstraintsDockerImageMetadataNestedImpl<N> extends SecurityContextConstraintsFluentImpl<ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<N>> implements ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
    
            SecurityContextConstraintsDockerImageMetadataNestedImpl(SecurityContextConstraints item){
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
            SecurityContextConstraintsDockerImageMetadataNestedImpl(){
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withSecurityContextConstraintsDockerImageMetadata(builder.build());
    }
    public N endSecurityContextConstraintsDockerImageMetadata(){
            return and();
    }

}
    public class BuildConfigDockerImageMetadataNestedImpl<N> extends BuildConfigFluentImpl<ImageFluent.BuildConfigDockerImageMetadataNested<N>> implements ImageFluent.BuildConfigDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildConfigBuilder builder;
    
            BuildConfigDockerImageMetadataNestedImpl(BuildConfig item){
                    this.builder = new BuildConfigBuilder(this, item);
            }
            BuildConfigDockerImageMetadataNestedImpl(){
                    this.builder = new BuildConfigBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withBuildConfigDockerImageMetadata(builder.build());
    }
    public N endBuildConfigDockerImageMetadata(){
            return and();
    }

}
    public class RouteDockerImageMetadataNestedImpl<N> extends RouteFluentImpl<ImageFluent.RouteDockerImageMetadataNested<N>> implements ImageFluent.RouteDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
    
            RouteDockerImageMetadataNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
            RouteDockerImageMetadataNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withRouteDockerImageMetadata(builder.build());
    }
    public N endRouteDockerImageMetadata(){
            return and();
    }

}
    public class OAuthAuthorizeTokenDockerImageMetadataNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<N>> implements ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
    
            OAuthAuthorizeTokenDockerImageMetadataNestedImpl(OAuthAuthorizeToken item){
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
            OAuthAuthorizeTokenDockerImageMetadataNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withOAuthAuthorizeTokenDockerImageMetadata(builder.build());
    }
    public N endOAuthAuthorizeTokenDockerImageMetadata(){
            return and();
    }

}
    public class NamespaceDockerImageMetadataNestedImpl<N> extends NamespaceFluentImpl<ImageFluent.NamespaceDockerImageMetadataNested<N>> implements ImageFluent.NamespaceDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamespaceBuilder builder;
    
            NamespaceDockerImageMetadataNestedImpl(Namespace item){
                    this.builder = new NamespaceBuilder(this, item);
            }
            NamespaceDockerImageMetadataNestedImpl(){
                    this.builder = new NamespaceBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withNamespaceDockerImageMetadata(builder.build());
    }
    public N endNamespaceDockerImageMetadata(){
            return and();
    }

}
    public class ClusterRoleBindingDockerImageMetadataNestedImpl<N> extends ClusterRoleBindingFluentImpl<ImageFluent.ClusterRoleBindingDockerImageMetadataNested<N>> implements ImageFluent.ClusterRoleBindingDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            ClusterRoleBindingDockerImageMetadataNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
            ClusterRoleBindingDockerImageMetadataNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withClusterRoleBindingDockerImageMetadata(builder.build());
    }
    public N endClusterRoleBindingDockerImageMetadata(){
            return and();
    }

}
    public class ServiceDockerImageMetadataNestedImpl<N> extends ServiceFluentImpl<ImageFluent.ServiceDockerImageMetadataNested<N>> implements ImageFluent.ServiceDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceBuilder builder;
    
            ServiceDockerImageMetadataNestedImpl(Service item){
                    this.builder = new ServiceBuilder(this, item);
            }
            ServiceDockerImageMetadataNestedImpl(){
                    this.builder = new ServiceBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withServiceDockerImageMetadata(builder.build());
    }
    public N endServiceDockerImageMetadata(){
            return and();
    }

}
    public class ReplicationControllerDockerImageMetadataNestedImpl<N> extends ReplicationControllerFluentImpl<ImageFluent.ReplicationControllerDockerImageMetadataNested<N>> implements ImageFluent.ReplicationControllerDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReplicationControllerBuilder builder;
    
            ReplicationControllerDockerImageMetadataNestedImpl(ReplicationController item){
                    this.builder = new ReplicationControllerBuilder(this, item);
            }
            ReplicationControllerDockerImageMetadataNestedImpl(){
                    this.builder = new ReplicationControllerBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withReplicationControllerDockerImageMetadata(builder.build());
    }
    public N endReplicationControllerDockerImageMetadata(){
            return and();
    }

}
    public class ProjectRequestDockerImageMetadataNestedImpl<N> extends ProjectRequestFluentImpl<ImageFluent.ProjectRequestDockerImageMetadataNested<N>> implements ImageFluent.ProjectRequestDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectRequestBuilder builder;
    
            ProjectRequestDockerImageMetadataNestedImpl(ProjectRequest item){
                    this.builder = new ProjectRequestBuilder(this, item);
            }
            ProjectRequestDockerImageMetadataNestedImpl(){
                    this.builder = new ProjectRequestBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withProjectRequestDockerImageMetadata(builder.build());
    }
    public N endProjectRequestDockerImageMetadata(){
            return and();
    }

}
    public class TemplateDockerImageMetadataNestedImpl<N> extends TemplateFluentImpl<ImageFluent.TemplateDockerImageMetadataNested<N>> implements ImageFluent.TemplateDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TemplateBuilder builder;
    
            TemplateDockerImageMetadataNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
            TemplateDockerImageMetadataNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withTemplateDockerImageMetadata(builder.build());
    }
    public N endTemplateDockerImageMetadata(){
            return and();
    }

}
    public class OAuthClientAuthorizationDockerImageMetadataNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<N>> implements ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
    
            OAuthClientAuthorizationDockerImageMetadataNestedImpl(OAuthClientAuthorization item){
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
            OAuthClientAuthorizationDockerImageMetadataNestedImpl(){
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withOAuthClientAuthorizationDockerImageMetadata(builder.build());
    }
    public N endOAuthClientAuthorizationDockerImageMetadata(){
            return and();
    }

}
    public class PolicyBindingDockerImageMetadataNestedImpl<N> extends PolicyBindingFluentImpl<ImageFluent.PolicyBindingDockerImageMetadataNested<N>> implements ImageFluent.PolicyBindingDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PolicyBindingBuilder builder;
    
            PolicyBindingDockerImageMetadataNestedImpl(PolicyBinding item){
                    this.builder = new PolicyBindingBuilder(this, item);
            }
            PolicyBindingDockerImageMetadataNestedImpl(){
                    this.builder = new PolicyBindingBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPolicyBindingDockerImageMetadata(builder.build());
    }
    public N endPolicyBindingDockerImageMetadata(){
            return and();
    }

}
    public class ClusterRoleDockerImageMetadataNestedImpl<N> extends ClusterRoleFluentImpl<ImageFluent.ClusterRoleDockerImageMetadataNested<N>> implements ImageFluent.ClusterRoleDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBuilder builder;
    
            ClusterRoleDockerImageMetadataNestedImpl(ClusterRole item){
                    this.builder = new ClusterRoleBuilder(this, item);
            }
            ClusterRoleDockerImageMetadataNestedImpl(){
                    this.builder = new ClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withClusterRoleDockerImageMetadata(builder.build());
    }
    public N endClusterRoleDockerImageMetadata(){
            return and();
    }

}
    public class ScaleDockerImageMetadataNestedImpl<N> extends ScaleFluentImpl<ImageFluent.ScaleDockerImageMetadataNested<N>> implements ImageFluent.ScaleDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ScaleBuilder builder;
    
            ScaleDockerImageMetadataNestedImpl(Scale item){
                    this.builder = new ScaleBuilder(this, item);
            }
            ScaleDockerImageMetadataNestedImpl(){
                    this.builder = new ScaleBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withScaleDockerImageMetadata(builder.build());
    }
    public N endScaleDockerImageMetadata(){
            return and();
    }

}
    public class PodTemplateDockerImageMetadataNestedImpl<N> extends PodTemplateFluentImpl<ImageFluent.PodTemplateDockerImageMetadataNested<N>> implements ImageFluent.PodTemplateDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodTemplateDockerImageMetadataNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodTemplateDockerImageMetadataNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPodTemplateDockerImageMetadata(builder.build());
    }
    public N endPodTemplateDockerImageMetadata(){
            return and();
    }

}
    public class EventDockerImageMetadataNestedImpl<N> extends EventFluentImpl<ImageFluent.EventDockerImageMetadataNested<N>> implements ImageFluent.EventDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EventBuilder builder;
    
            EventDockerImageMetadataNestedImpl(Event item){
                    this.builder = new EventBuilder(this, item);
            }
            EventDockerImageMetadataNestedImpl(){
                    this.builder = new EventBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withEventDockerImageMetadata(builder.build());
    }
    public N endEventDockerImageMetadata(){
            return and();
    }

}
    public class IngressDockerImageMetadataNestedImpl<N> extends IngressFluentImpl<ImageFluent.IngressDockerImageMetadataNested<N>> implements ImageFluent.IngressDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressBuilder builder;
    
            IngressDockerImageMetadataNestedImpl(Ingress item){
                    this.builder = new IngressBuilder(this, item);
            }
            IngressDockerImageMetadataNestedImpl(){
                    this.builder = new IngressBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withIngressDockerImageMetadata(builder.build());
    }
    public N endIngressDockerImageMetadata(){
            return and();
    }

}
    public class DeploymentConfigDockerImageMetadataNestedImpl<N> extends DeploymentConfigFluentImpl<ImageFluent.DeploymentConfigDockerImageMetadataNested<N>> implements ImageFluent.DeploymentConfigDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentConfigBuilder builder;
    
            DeploymentConfigDockerImageMetadataNestedImpl(DeploymentConfig item){
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
            DeploymentConfigDockerImageMetadataNestedImpl(){
                    this.builder = new DeploymentConfigBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withDeploymentConfigDockerImageMetadata(builder.build());
    }
    public N endDeploymentConfigDockerImageMetadata(){
            return and();
    }

}
    public class OAuthAccessTokenDockerImageMetadataNestedImpl<N> extends OAuthAccessTokenFluentImpl<ImageFluent.OAuthAccessTokenDockerImageMetadataNested<N>> implements ImageFluent.OAuthAccessTokenDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            OAuthAccessTokenDockerImageMetadataNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
            OAuthAccessTokenDockerImageMetadataNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withOAuthAccessTokenDockerImageMetadata(builder.build());
    }
    public N endOAuthAccessTokenDockerImageMetadata(){
            return and();
    }

}
    public class RoleBindingDockerImageMetadataNestedImpl<N> extends RoleBindingFluentImpl<ImageFluent.RoleBindingDockerImageMetadataNested<N>> implements ImageFluent.RoleBindingDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingDockerImageMetadataNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
            RoleBindingDockerImageMetadataNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withRoleBindingDockerImageMetadata(builder.build());
    }
    public N endRoleBindingDockerImageMetadata(){
            return and();
    }

}
    public class PersistentVolumeDockerImageMetadataNestedImpl<N> extends PersistentVolumeFluentImpl<ImageFluent.PersistentVolumeDockerImageMetadataNested<N>> implements ImageFluent.PersistentVolumeDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeBuilder builder;
    
            PersistentVolumeDockerImageMetadataNestedImpl(PersistentVolume item){
                    this.builder = new PersistentVolumeBuilder(this, item);
            }
            PersistentVolumeDockerImageMetadataNestedImpl(){
                    this.builder = new PersistentVolumeBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPersistentVolumeDockerImageMetadata(builder.build());
    }
    public N endPersistentVolumeDockerImageMetadata(){
            return and();
    }

}
    public class ImageDockerImageMetadataNestedImpl<N> extends ImageFluentImpl<ImageFluent.ImageDockerImageMetadataNested<N>> implements ImageFluent.ImageDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageBuilder builder;
    
            ImageDockerImageMetadataNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
            ImageDockerImageMetadataNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withImageDockerImageMetadata(builder.build());
    }
    public N endImageDockerImageMetadata(){
            return and();
    }

}
    public class PersistentVolumeClaimDockerImageMetadataNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<N>> implements ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            PersistentVolumeClaimDockerImageMetadataNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            PersistentVolumeClaimDockerImageMetadataNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPersistentVolumeClaimDockerImageMetadata(builder.build());
    }
    public N endPersistentVolumeClaimDockerImageMetadata(){
            return and();
    }

}
    public class ReplicaSetDockerImageMetadataNestedImpl<N> extends ReplicaSetFluentImpl<ImageFluent.ReplicaSetDockerImageMetadataNested<N>> implements ImageFluent.ReplicaSetDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReplicaSetBuilder builder;
    
            ReplicaSetDockerImageMetadataNestedImpl(ReplicaSet item){
                    this.builder = new ReplicaSetBuilder(this, item);
            }
            ReplicaSetDockerImageMetadataNestedImpl(){
                    this.builder = new ReplicaSetBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withReplicaSetDockerImageMetadata(builder.build());
    }
    public N endReplicaSetDockerImageMetadata(){
            return and();
    }

}
    public class RoleDockerImageMetadataNestedImpl<N> extends RoleFluentImpl<ImageFluent.RoleDockerImageMetadataNested<N>> implements ImageFluent.RoleDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBuilder builder;
    
            RoleDockerImageMetadataNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
            RoleDockerImageMetadataNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withRoleDockerImageMetadata(builder.build());
    }
    public N endRoleDockerImageMetadata(){
            return and();
    }

}
    public class EndpointsDockerImageMetadataNestedImpl<N> extends EndpointsFluentImpl<ImageFluent.EndpointsDockerImageMetadataNested<N>> implements ImageFluent.EndpointsDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EndpointsBuilder builder;
    
            EndpointsDockerImageMetadataNestedImpl(Endpoints item){
                    this.builder = new EndpointsBuilder(this, item);
            }
            EndpointsDockerImageMetadataNestedImpl(){
                    this.builder = new EndpointsBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withEndpointsDockerImageMetadata(builder.build());
    }
    public N endEndpointsDockerImageMetadata(){
            return and();
    }

}
    public class PodDockerImageMetadataNestedImpl<N> extends PodFluentImpl<ImageFluent.PodDockerImageMetadataNested<N>> implements ImageFluent.PodDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodBuilder builder;
    
            PodDockerImageMetadataNestedImpl(Pod item){
                    this.builder = new PodBuilder(this, item);
            }
            PodDockerImageMetadataNestedImpl(){
                    this.builder = new PodBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPodDockerImageMetadata(builder.build());
    }
    public N endPodDockerImageMetadata(){
            return and();
    }

}
    public class ConfigMapDockerImageMetadataNestedImpl<N> extends ConfigMapFluentImpl<ImageFluent.ConfigMapDockerImageMetadataNested<N>> implements ImageFluent.ConfigMapDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapBuilder builder;
    
            ConfigMapDockerImageMetadataNestedImpl(ConfigMap item){
                    this.builder = new ConfigMapBuilder(this, item);
            }
            ConfigMapDockerImageMetadataNestedImpl(){
                    this.builder = new ConfigMapBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withConfigMapDockerImageMetadata(builder.build());
    }
    public N endConfigMapDockerImageMetadata(){
            return and();
    }

}
    public class ClusterPolicyDockerImageMetadataNestedImpl<N> extends ClusterPolicyFluentImpl<ImageFluent.ClusterPolicyDockerImageMetadataNested<N>> implements ImageFluent.ClusterPolicyDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterPolicyBuilder builder;
    
            ClusterPolicyDockerImageMetadataNestedImpl(ClusterPolicy item){
                    this.builder = new ClusterPolicyBuilder(this, item);
            }
            ClusterPolicyDockerImageMetadataNestedImpl(){
                    this.builder = new ClusterPolicyBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withClusterPolicyDockerImageMetadata(builder.build());
    }
    public N endClusterPolicyDockerImageMetadata(){
            return and();
    }

}
    public class DaemonSetDockerImageMetadataNestedImpl<N> extends DaemonSetFluentImpl<ImageFluent.DaemonSetDockerImageMetadataNested<N>> implements ImageFluent.DaemonSetDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DaemonSetBuilder builder;
    
            DaemonSetDockerImageMetadataNestedImpl(DaemonSet item){
                    this.builder = new DaemonSetBuilder(this, item);
            }
            DaemonSetDockerImageMetadataNestedImpl(){
                    this.builder = new DaemonSetBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withDaemonSetDockerImageMetadata(builder.build());
    }
    public N endDaemonSetDockerImageMetadata(){
            return and();
    }

}
    public class DeploymentDockerImageMetadataNestedImpl<N> extends DeploymentFluentImpl<ImageFluent.DeploymentDockerImageMetadataNested<N>> implements ImageFluent.DeploymentDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentBuilder builder;
    
            DeploymentDockerImageMetadataNestedImpl(Deployment item){
                    this.builder = new DeploymentBuilder(this, item);
            }
            DeploymentDockerImageMetadataNestedImpl(){
                    this.builder = new DeploymentBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withDeploymentDockerImageMetadata(builder.build());
    }
    public N endDeploymentDockerImageMetadata(){
            return and();
    }

}
    public class UserDockerImageMetadataNestedImpl<N> extends UserFluentImpl<ImageFluent.UserDockerImageMetadataNested<N>> implements ImageFluent.UserDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserBuilder builder;
    
            UserDockerImageMetadataNestedImpl(User item){
                    this.builder = new UserBuilder(this, item);
            }
            UserDockerImageMetadataNestedImpl(){
                    this.builder = new UserBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withUserDockerImageMetadata(builder.build());
    }
    public N endUserDockerImageMetadata(){
            return and();
    }

}
    public class ComponentStatusDockerImageMetadataNestedImpl<N> extends ComponentStatusFluentImpl<ImageFluent.ComponentStatusDockerImageMetadataNested<N>> implements ImageFluent.ComponentStatusDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ComponentStatusBuilder builder;
    
            ComponentStatusDockerImageMetadataNestedImpl(ComponentStatus item){
                    this.builder = new ComponentStatusBuilder(this, item);
            }
            ComponentStatusDockerImageMetadataNestedImpl(){
                    this.builder = new ComponentStatusBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withComponentStatusDockerImageMetadata(builder.build());
    }
    public N endComponentStatusDockerImageMetadata(){
            return and();
    }

}
    public class BuildDockerImageMetadataNestedImpl<N> extends BuildFluentImpl<ImageFluent.BuildDockerImageMetadataNested<N>> implements ImageFluent.BuildDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildBuilder builder;
    
            BuildDockerImageMetadataNestedImpl(Build item){
                    this.builder = new BuildBuilder(this, item);
            }
            BuildDockerImageMetadataNestedImpl(){
                    this.builder = new BuildBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withBuildDockerImageMetadata(builder.build());
    }
    public N endBuildDockerImageMetadata(){
            return and();
    }

}
    public class ImageStreamTagDockerImageMetadataNestedImpl<N> extends ImageStreamTagFluentImpl<ImageFluent.ImageStreamTagDockerImageMetadataNested<N>> implements ImageFluent.ImageStreamTagDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamTagBuilder builder;
    
            ImageStreamTagDockerImageMetadataNestedImpl(ImageStreamTag item){
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
            ImageStreamTagDockerImageMetadataNestedImpl(){
                    this.builder = new ImageStreamTagBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withImageStreamTagDockerImageMetadata(builder.build());
    }
    public N endImageStreamTagDockerImageMetadata(){
            return and();
    }

}
    public class GroupDockerImageMetadataNestedImpl<N> extends GroupFluentImpl<ImageFluent.GroupDockerImageMetadataNested<N>> implements ImageFluent.GroupDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupBuilder builder;
    
            GroupDockerImageMetadataNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
            GroupDockerImageMetadataNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withGroupDockerImageMetadata(builder.build());
    }
    public N endGroupDockerImageMetadata(){
            return and();
    }

}
    public class PetSetDockerImageMetadataNestedImpl<N> extends PetSetFluentImpl<ImageFluent.PetSetDockerImageMetadataNested<N>> implements ImageFluent.PetSetDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PetSetBuilder builder;
    
            PetSetDockerImageMetadataNestedImpl(PetSet item){
                    this.builder = new PetSetBuilder(this, item);
            }
            PetSetDockerImageMetadataNestedImpl(){
                    this.builder = new PetSetBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPetSetDockerImageMetadata(builder.build());
    }
    public N endPetSetDockerImageMetadata(){
            return and();
    }

}
    public class PolicyDockerImageMetadataNestedImpl<N> extends PolicyFluentImpl<ImageFluent.PolicyDockerImageMetadataNested<N>> implements ImageFluent.PolicyDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PolicyBuilder builder;
    
            PolicyDockerImageMetadataNestedImpl(Policy item){
                    this.builder = new PolicyBuilder(this, item);
            }
            PolicyDockerImageMetadataNestedImpl(){
                    this.builder = new PolicyBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withPolicyDockerImageMetadata(builder.build());
    }
    public N endPolicyDockerImageMetadata(){
            return and();
    }

}
    public class ImageSignatureDockerImageMetadataNestedImpl<N> extends ImageSignatureFluentImpl<ImageFluent.ImageSignatureDockerImageMetadataNested<N>> implements ImageFluent.ImageSignatureDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
    
            ImageSignatureDockerImageMetadataNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            ImageSignatureDockerImageMetadataNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withImageSignatureDockerImageMetadata(builder.build());
    }
    public N endImageSignatureDockerImageMetadata(){
            return and();
    }

}
    public class BindingDockerImageMetadataNestedImpl<N> extends BindingFluentImpl<ImageFluent.BindingDockerImageMetadataNested<N>> implements ImageFluent.BindingDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BindingBuilder builder;
    
            BindingDockerImageMetadataNestedImpl(Binding item){
                    this.builder = new BindingBuilder(this, item);
            }
            BindingDockerImageMetadataNestedImpl(){
                    this.builder = new BindingBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withBindingDockerImageMetadata(builder.build());
    }
    public N endBindingDockerImageMetadata(){
            return and();
    }

}
    public class ResourceQuotaDockerImageMetadataNestedImpl<N> extends ResourceQuotaFluentImpl<ImageFluent.ResourceQuotaDockerImageMetadataNested<N>> implements ImageFluent.ResourceQuotaDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceQuotaBuilder builder;
    
            ResourceQuotaDockerImageMetadataNestedImpl(ResourceQuota item){
                    this.builder = new ResourceQuotaBuilder(this, item);
            }
            ResourceQuotaDockerImageMetadataNestedImpl(){
                    this.builder = new ResourceQuotaBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withResourceQuotaDockerImageMetadata(builder.build());
    }
    public N endResourceQuotaDockerImageMetadata(){
            return and();
    }

}
    public class SecretDockerImageMetadataNestedImpl<N> extends SecretFluentImpl<ImageFluent.SecretDockerImageMetadataNested<N>> implements ImageFluent.SecretDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretBuilder builder;
    
            SecretDockerImageMetadataNestedImpl(Secret item){
                    this.builder = new SecretBuilder(this, item);
            }
            SecretDockerImageMetadataNestedImpl(){
                    this.builder = new SecretBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withSecretDockerImageMetadata(builder.build());
    }
    public N endSecretDockerImageMetadata(){
            return and();
    }

}
    public class BuildRequestDockerImageMetadataNestedImpl<N> extends BuildRequestFluentImpl<ImageFluent.BuildRequestDockerImageMetadataNested<N>> implements ImageFluent.BuildRequestDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildRequestBuilder builder;
    
            BuildRequestDockerImageMetadataNestedImpl(BuildRequest item){
                    this.builder = new BuildRequestBuilder(this, item);
            }
            BuildRequestDockerImageMetadataNestedImpl(){
                    this.builder = new BuildRequestBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withBuildRequestDockerImageMetadata(builder.build());
    }
    public N endBuildRequestDockerImageMetadata(){
            return and();
    }

}
    public class ClusterPolicyBindingDockerImageMetadataNestedImpl<N> extends ClusterPolicyBindingFluentImpl<ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<N>> implements ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterPolicyBindingBuilder builder;
    
            ClusterPolicyBindingDockerImageMetadataNestedImpl(ClusterPolicyBinding item){
                    this.builder = new ClusterPolicyBindingBuilder(this, item);
            }
            ClusterPolicyBindingDockerImageMetadataNestedImpl(){
                    this.builder = new ClusterPolicyBindingBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withClusterPolicyBindingDockerImageMetadata(builder.build());
    }
    public N endClusterPolicyBindingDockerImageMetadata(){
            return and();
    }

}
    public class NodeDockerImageMetadataNestedImpl<N> extends NodeFluentImpl<ImageFluent.NodeDockerImageMetadataNested<N>> implements ImageFluent.NodeDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeBuilder builder;
    
            NodeDockerImageMetadataNestedImpl(Node item){
                    this.builder = new NodeBuilder(this, item);
            }
            NodeDockerImageMetadataNestedImpl(){
                    this.builder = new NodeBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withNodeDockerImageMetadata(builder.build());
    }
    public N endNodeDockerImageMetadata(){
            return and();
    }

}
    public class ImageStreamDockerImageMetadataNestedImpl<N> extends ImageStreamFluentImpl<ImageFluent.ImageStreamDockerImageMetadataNested<N>> implements ImageFluent.ImageStreamDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamBuilder builder;
    
            ImageStreamDockerImageMetadataNestedImpl(ImageStream item){
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamDockerImageMetadataNestedImpl(){
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withImageStreamDockerImageMetadata(builder.build());
    }
    public N endImageStreamDockerImageMetadata(){
            return and();
    }

}
    public class HorizontalPodAutoscalerDockerImageMetadataNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<N>> implements ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HorizontalPodAutoscalerBuilder builder;
    
            HorizontalPodAutoscalerDockerImageMetadataNestedImpl(HorizontalPodAutoscaler item){
                    this.builder = new HorizontalPodAutoscalerBuilder(this, item);
            }
            HorizontalPodAutoscalerDockerImageMetadataNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withHorizontalPodAutoscalerDockerImageMetadata(builder.build());
    }
    public N endHorizontalPodAutoscalerDockerImageMetadata(){
            return and();
    }

}
    public class OAuthClientDockerImageMetadataNestedImpl<N> extends OAuthClientFluentImpl<ImageFluent.OAuthClientDockerImageMetadataNested<N>> implements ImageFluent.OAuthClientDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientBuilder builder;
    
            OAuthClientDockerImageMetadataNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
            OAuthClientDockerImageMetadataNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withOAuthClientDockerImageMetadata(builder.build());
    }
    public N endOAuthClientDockerImageMetadata(){
            return and();
    }

}
    public class ServiceAccountDockerImageMetadataNestedImpl<N> extends ServiceAccountFluentImpl<ImageFluent.ServiceAccountDockerImageMetadataNested<N>> implements ImageFluent.ServiceAccountDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceAccountBuilder builder;
    
            ServiceAccountDockerImageMetadataNestedImpl(ServiceAccount item){
                    this.builder = new ServiceAccountBuilder(this, item);
            }
            ServiceAccountDockerImageMetadataNestedImpl(){
                    this.builder = new ServiceAccountBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withServiceAccountDockerImageMetadata(builder.build());
    }
    public N endServiceAccountDockerImageMetadata(){
            return and();
    }

}
    public class IdentityDockerImageMetadataNestedImpl<N> extends IdentityFluentImpl<ImageFluent.IdentityDockerImageMetadataNested<N>> implements ImageFluent.IdentityDockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IdentityBuilder builder;
    
            IdentityDockerImageMetadataNestedImpl(Identity item){
                    this.builder = new IdentityBuilder(this, item);
            }
            IdentityDockerImageMetadataNestedImpl(){
                    this.builder = new IdentityBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withIdentityDockerImageMetadata(builder.build());
    }
    public N endIdentityDockerImageMetadata(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageFluent.MetadataNested<N>> implements ImageFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SignaturesNestedImpl<N> extends ImageSignatureFluentImpl<ImageFluent.SignaturesNested<N>> implements ImageFluent.SignaturesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
    
            SignaturesNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            SignaturesNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.addToSignatures(builder.build());
    }
    public N endSignature(){
            return and();
    }

}


}
