package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;

public class ImageSourceFluentImpl<A extends ImageSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageSourceFluent<A>{

    private VisitableBuilder<? extends ObjectReference,?> from;
    private List<VisitableBuilder<? extends ImageSourcePath,?>> paths =  new ArrayList<VisitableBuilder<? extends ImageSourcePath,?>>();
    private VisitableBuilder<? extends LocalObjectReference,?> pullSecret;

    public ImageSourceFluentImpl(){
    }
    public ImageSourceFluentImpl(ImageSource instance){
            this.withFrom(instance.getFrom()); 
            this.withPaths(instance.getPaths()); 
            this.withPullSecret(instance.getPullSecret()); 
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            _visitables.remove(this.from);
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public ImageSourceFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public ImageSourceFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public ImageSourceFluent.FromNested<A> editOrNewFrom(){
            return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public ImageSourceFluent.FromNested<A> editOrNewFromLike(ObjectReference item){
            return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public A addToPaths(ImageSourcePath... items){
            for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.add(builder);this.paths.add(builder);} return (A)this;
    }

    public A removeFromPaths(ImageSourcePath... items){
            for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.remove(builder);this.paths.remove(builder);} return (A)this;
    }

    public List<ImageSourcePath> getPaths(){
            return build(paths);
    }

    public A withPaths(List<ImageSourcePath> paths){
            _visitables.removeAll(this.paths);
            this.paths.clear();
            if (paths != null) {for (ImageSourcePath item : paths){this.addToPaths(item);}} return (A) this;
    }

    public A withPaths(ImageSourcePath... paths){
            this.paths.clear(); if (paths != null) {for (ImageSourcePath item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public ImageSourceFluent.PathsNested<A> addNewPath(){
            return new PathsNestedImpl();
    }

    public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item){
            return new PathsNestedImpl(item);
    }

    public A addNewPath(String destinationDir,String sourcePath){
            return (A)addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    public LocalObjectReference getPullSecret(){
            return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(LocalObjectReference pullSecret){
            _visitables.remove(this.pullSecret);
            if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (A) this;
    }

    public ImageSourceFluent.PullSecretNested<A> withNewPullSecret(){
            return new PullSecretNestedImpl();
    }

    public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item){
            return new PullSecretNestedImpl(item);
    }

    public ImageSourceFluent.PullSecretNested<A> editPullSecret(){
            return withNewPullSecretLike(getPullSecret());
    }

    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret(){
            return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
    }

    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item){
            return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public A withNewPullSecret(String name){
            return (A)withPullSecret(new LocalObjectReference(name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageSourceFluentImpl that = (ImageSourceFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
            if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<ImageSourceFluent.FromNested<N>> implements ImageSourceFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ImageSourceFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom(){
            return and();
    }

}
    public class PathsNestedImpl<N> extends ImageSourcePathFluentImpl<ImageSourceFluent.PathsNested<N>> implements ImageSourceFluent.PathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSourcePathBuilder builder;
    
            PathsNestedImpl(ImageSourcePath item){
                    this.builder = new ImageSourcePathBuilder(this, item);
            }
            PathsNestedImpl(){
                    this.builder = new ImageSourcePathBuilder(this);
            }
    
    public N and(){
            return (N) ImageSourceFluentImpl.this.addToPaths(builder.build());
    }
    public N endPath(){
            return and();
    }

}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<ImageSourceFluent.PullSecretNested<N>> implements ImageSourceFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            PullSecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
            PullSecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ImageSourceFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret(){
            return and();
    }

}


}
