package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ImageStreamStatusBuilder extends ImageStreamStatusFluentImpl<ImageStreamStatusBuilder> implements VisitableBuilder<ImageStreamStatus,ImageStreamStatusBuilder>{

    ImageStreamStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamStatusBuilder(){
            this(true);
    }
    public ImageStreamStatusBuilder(Boolean validationEnabled){
            this(new ImageStreamStatus(), validationEnabled);
    }
    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageStreamStatus(), validationEnabled);
    }
    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent,ImageStreamStatus instance){
            this(fluent, instance, true);
    }
    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent,ImageStreamStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDockerImageRepository(instance.getDockerImageRepository()); 
            fluent.withTags(instance.getTags()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageStreamStatusBuilder(ImageStreamStatus instance){
            this(instance,true);
    }
    public ImageStreamStatusBuilder(ImageStreamStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDockerImageRepository(instance.getDockerImageRepository()); 
            this.withTags(instance.getTags()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageStreamStatus build(){
            ImageStreamStatus buildable = new ImageStreamStatus(fluent.getDockerImageRepository(),fluent.getTags());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamStatusBuilder that = (ImageStreamStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
