package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ImageStreamStatusFluentImpl<A extends ImageStreamStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageStreamStatusFluent<A>{

    private String dockerImageRepository;
    private List<VisitableBuilder<? extends NamedTagEventList,?>> tags =  new ArrayList<VisitableBuilder<? extends NamedTagEventList,?>>();

    public ImageStreamStatusFluentImpl(){
    }
    public ImageStreamStatusFluentImpl(ImageStreamStatus instance){
            this.withDockerImageRepository(instance.getDockerImageRepository()); 
            this.withTags(instance.getTags()); 
    }

    public String getDockerImageRepository(){
            return this.dockerImageRepository;
    }

    public A withDockerImageRepository(String dockerImageRepository){
            this.dockerImageRepository=dockerImageRepository; return (A) this;
    }

    public A addToTags(NamedTagEventList... items){
            for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (A)this;
    }

    public A removeFromTags(NamedTagEventList... items){
            for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.remove(builder);this.tags.remove(builder);} return (A)this;
    }

    public List<NamedTagEventList> getTags(){
            return build(tags);
    }

    public A withTags(List<NamedTagEventList> tags){
            _visitables.removeAll(this.tags);
            this.tags.clear();
            if (tags != null) {for (NamedTagEventList item : tags){this.addToTags(item);}} return (A) this;
    }

    public A withTags(NamedTagEventList... tags){
            this.tags.clear(); if (tags != null) {for (NamedTagEventList item :tags){ this.addToTags(item);}} return (A) this;
    }

    public ImageStreamStatusFluent.TagsNested<A> addNewTag(){
            return new TagsNestedImpl();
    }

    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item){
            return new TagsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamStatusFluentImpl that = (ImageStreamStatusFluentImpl) o;
            if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
            if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
            return true;
    }


    public class TagsNestedImpl<N> extends NamedTagEventListFluentImpl<ImageStreamStatusFluent.TagsNested<N>> implements ImageStreamStatusFluent.TagsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamedTagEventListBuilder builder;
    
            TagsNestedImpl(NamedTagEventList item){
                    this.builder = new NamedTagEventListBuilder(this, item);
            }
            TagsNestedImpl(){
                    this.builder = new NamedTagEventListBuilder(this);
            }
    
    public N and(){
            return (N) ImageStreamStatusFluentImpl.this.addToTags(builder.build());
    }
    public N endTag(){
            return and();
    }

}


}
