package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class OAuthClientAuthorizationListBuilder extends OAuthClientAuthorizationListFluentImpl<OAuthClientAuthorizationListBuilder> implements VisitableBuilder<OAuthClientAuthorizationList,OAuthClientAuthorizationListBuilder>{

    OAuthClientAuthorizationListFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthClientAuthorizationListBuilder(){
            this(true);
    }
    public OAuthClientAuthorizationListBuilder(Boolean validationEnabled){
            this(new OAuthClientAuthorizationList(), validationEnabled);
    }
    public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent){
            this(fluent, true);
    }
    public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OAuthClientAuthorizationList(), validationEnabled);
    }
    public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent,OAuthClientAuthorizationList instance){
            this(fluent, instance, true);
    }
    public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent,OAuthClientAuthorizationList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationList instance){
            this(instance,true);
    }
    public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public OAuthClientAuthorizationList build(){
            OAuthClientAuthorizationList buildable = new OAuthClientAuthorizationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthClientAuthorizationListBuilder that = (OAuthClientAuthorizationListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
