package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface OAuthClientFluent<A extends OAuthClientFluent<A>> extends Fluent<A>{


    public A addToAdditionalSecrets(String... items);
    public A removeFromAdditionalSecrets(String... items);
    public List<String> getAdditionalSecrets();
    public A withAdditionalSecrets(List<String> additionalSecrets);
    public A withAdditionalSecrets(String... additionalSecrets);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getGrantMethod();
    public A withGrantMethod(String grantMethod);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public OAuthClientFluent.MetadataNested<A> withNewMetadata();
    public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthClientFluent.MetadataNested<A> editMetadata();
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadata();
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToRedirectURIs(String... items);
    public A removeFromRedirectURIs(String... items);
    public List<String> getRedirectURIs();
    public A withRedirectURIs(List<String> redirectURIs);
    public A withRedirectURIs(String... redirectURIs);
    public Boolean isRespondWithChallenges();
    public A withRespondWithChallenges(Boolean respondWithChallenges);
    public A addToScopeRestrictions(ScopeRestriction... items);
    public A removeFromScopeRestrictions(ScopeRestriction... items);
    public List<ScopeRestriction> getScopeRestrictions();
    public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions);
    public A withScopeRestrictions(ScopeRestriction... scopeRestrictions);
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction();
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item);
    public String getSecret();
    public A withSecret(String secret);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OAuthClientFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface ScopeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScopeRestrictionFluent<OAuthClientFluent.ScopeRestrictionsNested<N>>{

        
    public N and();    public N endScopeRestriction();
}


}
