package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PolicyBindingFluent<A extends PolicyBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getLastModified();
    public A withLastModified(String lastModified);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PolicyBindingFluent.MetadataNested<A> withNewMetadata();
    public PolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PolicyBindingFluent.MetadataNested<A> editMetadata();
    public PolicyBindingFluent.MetadataNested<A> editOrNewMetadata();
    public PolicyBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ObjectReference getPolicyRef();
    public A withPolicyRef(ObjectReference policyRef);
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item);
    public PolicyBindingFluent.PolicyRefNested<A> editPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRefLike(ObjectReference item);
    public A addToRoleBindings(NamedRoleBinding... items);
    public A removeFromRoleBindings(NamedRoleBinding... items);
    public List<NamedRoleBinding> getRoleBindings();
    public A withRoleBindings(List<NamedRoleBinding> roleBindings);
    public A withRoleBindings(NamedRoleBinding... roleBindings);
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding();
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedRoleBinding item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PolicyBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface PolicyRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<PolicyBindingFluent.PolicyRefNested<N>>{

        
    public N and();    public N endPolicyRef();
}
    public interface RoleBindingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedRoleBindingFluent<PolicyBindingFluent.RoleBindingsNested<N>>{

        
    public N and();    public N endRoleBinding();
}


}
