package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface RoleBindingFluent<A extends RoleBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToGroupNames(String... items);
    public A removeFromGroupNames(String... items);
    public List<String> getGroupNames();
    public A withGroupNames(List<String> groupNames);
    public A withGroupNames(String... groupNames);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public RoleBindingFluent.MetadataNested<A> withNewMetadata();
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RoleBindingFluent.MetadataNested<A> editMetadata();
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadata();
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ObjectReference getRoleRef();
    public A withRoleRef(ObjectReference roleRef);
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef();
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item);
    public RoleBindingFluent.RoleRefNested<A> editRoleRef();
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef();
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item);
    public A addToSubjects(ObjectReference... items);
    public A removeFromSubjects(ObjectReference... items);
    public List<ObjectReference> getSubjects();
    public A withSubjects(List<ObjectReference> subjects);
    public A withSubjects(ObjectReference... subjects);
    public RoleBindingFluent.SubjectsNested<A> addNewSubject();
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item);
    public A addToUserNames(String... items);
    public A removeFromUserNames(String... items);
    public List<String> getUserNames();
    public A withUserNames(List<String> userNames);
    public A withUserNames(String... userNames);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<RoleBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RoleRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<RoleBindingFluent.RoleRefNested<N>>{

        
    public N and();    public N endRoleRef();
}
    public interface SubjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<RoleBindingFluent.SubjectsNested<N>>{

        
    public N and();    public N endSubject();
}


}
