package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface RouteSpecFluent<A extends RouteSpecFluent<A>> extends Fluent<A>{


    public A addToAlternateBackends(RouteTargetReference... items);
    public A removeFromAlternateBackends(RouteTargetReference... items);
    public List<RouteTargetReference> getAlternateBackends();
    public A withAlternateBackends(List<RouteTargetReference> alternateBackends);
    public A withAlternateBackends(RouteTargetReference... alternateBackends);
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend();
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item);
    public A addNewAlternateBackend(String kind,String name,Integer weight);
    public String getHost();
    public A withHost(String host);
    public String getPath();
    public A withPath(String path);
    public RoutePort getPort();
    public A withPort(RoutePort port);
    public RouteSpecFluent.PortNested<A> withNewPort();
    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item);
    public RouteSpecFluent.PortNested<A> editPort();
    public RouteSpecFluent.PortNested<A> editOrNewPort();
    public RouteSpecFluent.PortNested<A> editOrNewPortLike(RoutePort item);
    public TLSConfig getTls();
    public A withTls(TLSConfig tls);
    public RouteSpecFluent.TlsNested<A> withNewTls();
    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item);
    public RouteSpecFluent.TlsNested<A> editTls();
    public RouteSpecFluent.TlsNested<A> editOrNewTls();
    public RouteSpecFluent.TlsNested<A> editOrNewTlsLike(TLSConfig item);
    public RouteTargetReference getTo();
    public A withTo(RouteTargetReference to);
    public RouteSpecFluent.ToNested<A> withNewTo();
    public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item);
    public RouteSpecFluent.ToNested<A> editTo();
    public RouteSpecFluent.ToNested<A> editOrNewTo();
    public RouteSpecFluent.ToNested<A> editOrNewToLike(RouteTargetReference item);
    public A withNewTo(String kind,String name,Integer weight);

    public interface AlternateBackendsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteTargetReferenceFluent<RouteSpecFluent.AlternateBackendsNested<N>>{

        
    public N and();    public N endAlternateBackend();
}
    public interface PortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoutePortFluent<RouteSpecFluent.PortNested<N>>{

        
    public N and();    public N endPort();
}
    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSConfigFluent<RouteSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTls();
}
    public interface ToNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteTargetReferenceFluent<RouteSpecFluent.ToNested<N>>{

        
    public N and();    public N endTo();
}


}
